/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public class ToolExecutorResult {
    private static final int NO_EXIT_VALUE = Integer.MIN_VALUE;
    private final List<String> commandLineTool;
    private final int exitValue;
    private final Throwable exception;

    public Throwable getException() {
        return this.exception;
    }

    public boolean isException() {
        return this.exception == null;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public List<String> getCommandLine() {
        return this.commandLineTool;
    }

    public String getCommandLineAsString() {
        return Joiner.on((char)' ').join(this.commandLineTool);
    }

    public String toString() {
        return "GalaxyToolResult [commandLineTool=" + this.commandLineTool + ", exitValue=" + this.exitValue + ", exception=" + this.exception + "]";
    }

    public ToolExecutorResult(List<String> commandLineTool, int exitValue) {
        Objects.requireNonNull(commandLineTool, "Command line can not be null");
        Preconditions.checkArgument((!commandLineTool.isEmpty() ? 1 : 0) != 0, (Object)"Command line can not be empty");
        this.commandLineTool = commandLineTool;
        this.exitValue = exitValue;
        this.exception = null;
    }

    public ToolExecutorResult(List<String> commandLineTool, Throwable e) {
        Objects.requireNonNull(commandLineTool, "Command line can not be null.");
        Preconditions.checkArgument((!commandLineTool.isEmpty() ? 1 : 0) != 0, (Object)"Command line can not be empty");
        this.commandLineTool = commandLineTool;
        this.exitValue = Integer.MIN_VALUE;
        this.exception = e;
    }
}

