/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.galaxytools.GalaxyToolXMLParserUtils;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;

public class ToolInfo {
    private static final String DEFAULT_VERSION = "unknown";
    private final String toolID;
    private final String toolName;
    private final String toolSource;
    private final String toolVersion;
    private final String description;
    private final List<String> interpreters;
    private final String cheetahScript;
    private final String dockerImage;

    public String getToolSource() {
        return this.toolSource;
    }

    public String getToolID() {
        return this.toolID;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInterpreter(boolean dockerEnabled) {
        return ToolInfo.selectInterpreter(this.interpreters, dockerEnabled);
    }

    public String getCheetahScript() {
        return this.cheetahScript;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    private static String selectInterpreter(List<String> interpreters, boolean dockerEnabled) {
        if (interpreters == null || interpreters.isEmpty()) {
            return "";
        }
        if (interpreters.size() == 1) {
            return interpreters.get(0);
        }
        if ("docker".equals(interpreters.get(0)) && !dockerEnabled) {
            return interpreters.get(1);
        }
        return interpreters.get(0);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("toolID", (Object)this.toolID).add("toolName", (Object)this.toolName).add("toolVersion", (Object)this.toolVersion).add("description", (Object)this.description).add("interpreters", this.interpreters).add("dockerImage", (Object)this.dockerImage).add("commandScript", (Object)this.cheetahScript).toString();
    }

    ToolInfo(Document document, String toolSource) throws EoulsanException {
        Objects.requireNonNull(document, "doc argument cannot be null");
        this.toolID = GalaxyToolXMLParserUtils.extractToolID(document);
        this.toolName = GalaxyToolXMLParserUtils.extractToolName(document);
        this.description = GalaxyToolXMLParserUtils.extractDescription(document);
        this.interpreters = GalaxyToolXMLParserUtils.extractInterpreters(document);
        this.dockerImage = Strings.emptyToNull((String)GalaxyToolXMLParserUtils.extractDockerImage(document));
        this.cheetahScript = Strings.emptyToNull((String)GalaxyToolXMLParserUtils.extractCheetahScript(document));
        String toolVersion = Strings.nullToEmpty((String)GalaxyToolXMLParserUtils.extractToolVersion(document));
        this.toolVersion = "".equals(toolVersion) ? DEFAULT_VERSION : toolVersion;
        String string = this.toolSource = toolSource == null ? "unknown source" : toolSource;
        if (this.toolName == null) {
            throw new EoulsanException("GalaxyTool name can not be null");
        }
        if (this.cheetahScript == null) {
            throw new EoulsanException("No command found in Galaxy tool");
        }
    }
}

