/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.elements;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.ToolElement;
import java.util.Objects;
import org.w3c.dom.Element;

public abstract class AbstractToolElement
implements ToolElement {
    protected static final Splitter COMMA = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final String shortName;
    private final String name;
    private final String type;
    private Boolean isOptional = null;
    private String label = "";
    private String help = "";

    public Boolean isOptional() {
        return this.isOptional;
    }

    public String getLabel() {
        return this.label;
    }

    public String getHelp() {
        return this.help;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValidatedName() {
        return Naming.toValidName(this.name);
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "ParameterToolGalaxy [name=" + this.shortName + ", type=" + this.type + ", isOptional=" + this.isOptional + ", label=" + this.label + ", help=" + this.help + ", parameterEoulsan=" + this.getValue() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.help, this.isOptional, this.label, this.shortName, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractToolElement)) {
            return false;
        }
        AbstractToolElement that = (AbstractToolElement)obj;
        if (!Objects.equals(this.help, that.help)) {
            return false;
        }
        if (!Objects.equals(this.isOptional, that.isOptional)) {
            return false;
        }
        if (!Objects.equals(this.label, that.label)) {
            return false;
        }
        if (!Objects.equals(this.shortName, that.shortName)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public AbstractToolElement(Element param) {
        this(param, null);
    }

    public AbstractToolElement(Element param, String nameSpace) {
        this.shortName = param.getAttribute("name");
        this.name = nameSpace == null || nameSpace.isEmpty() ? this.shortName : nameSpace + "." + this.shortName;
        this.type = param.getAttribute("type");
        String optional = param.getAttribute("optional");
        this.isOptional = optional.isEmpty() ? null : Boolean.valueOf(Boolean.getBoolean(optional));
        this.label = param.getAttribute("label");
        this.help = param.getAttribute("help");
    }
}

