/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.elements;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.AbstractParameterToolElement;
import org.w3c.dom.Element;

public class BooleanParameterToolElement
extends AbstractParameterToolElement {
    public static final String TYPE = "boolean";
    private static final String ATT_CHECKED_KEY = "checked";
    private static final String ATT_TRUEVALUE_KEY = "truevalue";
    private static final String ATT_FALSEVALUE_KEY = "falsevalue";
    private final boolean checked;
    private final String trueValue;
    private final String falseValue;
    private boolean value;
    private boolean set;

    @Override
    public boolean isParameterValueValid() {
        return true;
    }

    @Override
    public String getValue() {
        return this.value ? this.trueValue : this.falseValue;
    }

    @Override
    public boolean isSet() {
        return this.set;
    }

    @Override
    public void setValue(String value) throws EoulsanException {
        if (value == null) {
            this.value = false;
            return;
        }
        switch (value.trim().toLowerCase()) {
            case "yes": 
            case "on": 
            case "true": {
                this.value = true;
                break;
            }
            default: {
                this.value = false;
            }
        }
        this.set = true;
    }

    @Override
    public String toString() {
        return "ToolParameterBoolean [checked=" + this.checked + ", trueValue=" + this.trueValue + ", falseValue=" + this.falseValue + ", value=" + this.value + "]";
    }

    public BooleanParameterToolElement(ToolInfo toolInfo, Element param) {
        this(toolInfo, param, null);
    }

    public BooleanParameterToolElement(ToolInfo toolInfo, Element param, String nameSpace) {
        super(param, nameSpace);
        this.checked = Boolean.parseBoolean(param.getAttribute(ATT_CHECKED_KEY));
        String trueValue = param.getAttribute(ATT_TRUEVALUE_KEY);
        this.trueValue = trueValue == null ? "" : trueValue;
        String falseValue = param.getAttribute(ATT_FALSEVALUE_KEY);
        this.falseValue = falseValue == null ? "" : falseValue;
        this.value = this.checked;
    }
}

