/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters;

import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters.AbstractExecutorInterpreter;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanDockerManager;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.process.SimpleProcess;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class DockerExecutorInterpreter
extends AbstractExecutorInterpreter {
    public static final String INTERPRETER_NAME = "docker";
    private final String dockerImage;

    @Override
    public String getName() {
        return INTERPRETER_NAME;
    }

    @Override
    public List<String> createCommandLine(String arguments) {
        Objects.requireNonNull(arguments, "arguments argument cannot be null");
        return StringUtils.splitShellCommandLine((String)arguments);
    }

    @Override
    protected SimpleProcess newSimpleProcess() throws IOException {
        return EoulsanDockerManager.getInstance().createImageInstance(this.dockerImage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("dockerImage", (Object)this.dockerImage).toString();
    }

    public DockerExecutorInterpreter(String dockerImage) {
        Objects.requireNonNull(dockerImage, "dockerImage argument cannot be null");
        this.dockerImage = dockerImage;
    }
}

