/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends FilterInputStream {
    private long nRead = 0L;
    private long size = 0L;
    private long attemptNRead = -1L;

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.attemptNRead < 0L) {
            return;
        }
        if (this.nRead != this.attemptNRead) {
            throw new IOException("Error read " + this.nRead + " bytes, attempted: " + this.attemptNRead + " bytes");
        }
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            ++this.nRead;
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.nRead += (long)nr;
        }
        return nr;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.nRead += (long)nr;
        }
        return nr;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nRead = this.size - (long)this.in.available();
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nRead += nr;
        }
        return nr;
    }

    public long getBytesRead() {
        return this.nRead;
    }

    public ByteCountInputStream(InputStream is) {
        super(is);
        try {
            this.size = is.available();
        }
        catch (IOException ioe) {
            this.size = 0L;
        }
    }

    public ByteCountInputStream(InputStream is, long attemptNRead) {
        this(is);
        this.attemptNRead = attemptNRead;
    }
}

