/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteCountOutputStream
extends FilterOutputStream {
    private long nWritten;
    private long attemptedNWritten = -1L;
    private boolean currentWrite;

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("the array of bytes argument cannot be null");
        }
        boolean add = false;
        if (!this.currentWrite) {
            add = true;
        }
        this.currentWrite = true;
        super.write(b, off, len);
        if (add) {
            this.nWritten += (long)len;
            this.currentWrite = false;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("the array of bytes argument cannot be null");
        }
        boolean add = false;
        if (!this.currentWrite) {
            add = true;
        }
        this.currentWrite = true;
        super.write(b);
        if (add) {
            this.nWritten += (long)b.length;
            this.currentWrite = false;
        }
    }

    @Override
    public void write(int b) throws IOException {
        boolean add = false;
        if (!this.currentWrite) {
            add = true;
        }
        this.currentWrite = true;
        super.write(b);
        if (add && this.currentWrite) {
            ++this.nWritten;
            this.currentWrite = false;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.attemptedNWritten < 0L) {
            return;
        }
        if (this.nWritten != this.attemptedNWritten) {
            throw new IOException("Error wrote " + this.nWritten + " bytes, attempted: " + this.attemptedNWritten + " bytes.");
        }
    }

    public long getBytesNumberWritten() {
        return this.nWritten;
    }

    public ByteCountOutputStream(OutputStream os) {
        super(os);
    }

    public ByteCountOutputStream(OutputStream os, long attemptedNWritten) {
        this(os);
        this.attemptedNWritten = attemptedNWritten;
    }
}

