/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.mapreduce.Counter;

public final class ProgressCounterInputStream
extends FilterInputStream {
    private static final int MAX = 0xA00000;
    private final Counter counter;
    private int sum;

    @Override
    public final int read() throws IOException {
        return this.incrementCounter(super.read());
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        return this.incrementCounter(super.read(b, off, len));
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.incrementCounter(super.read(b));
    }

    @Override
    public final void close() throws IOException {
        super.close();
        this.counter.increment((long)this.sum);
    }

    private int incrementCounter(int bytes) {
        this.sum += bytes;
        if (this.sum > 0xA00000) {
            this.counter.increment((long)this.sum);
            this.sum = 0;
        }
        return bytes;
    }

    public ProgressCounterInputStream(InputStream is, Counter counter) {
        super(is);
        if (counter == null) {
            throw new NullPointerException("The counter to use is null.");
        }
        this.counter = counter;
    }
}

