/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.NoLog;
import fr.ens.biologie.genomique.eoulsan.annotations.NoOutputDirectory;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.core.DataUtils;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.protocols.StorageDataProtocol;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

@LocalOnly
@ReuseModuleInstance
@NoLog
@NoOutputDirectory
public class CopyInputDataModule
extends AbstractModule {
    public static final String MODULE_NAME = "_copyinputformat";
    public static final String FORMAT_PARAMETER = "format";
    public static final String OUTPUT_COMPRESSION_PARAMETER = "output.compression";
    public static final String OUTPUT_COMPRESSIONS_ALLOWED_PARAMETER = "output.compressions.allowed";
    private DataFormat format;
    private CompressionType outputCompression;
    private EnumSet<CompressionType> outputCompressionsAllowed = EnumSet.allOf(CompressionType.class);

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(this.format);
    }

    @Override
    public OutputPorts getOutputPorts() {
        return new OutputPortsBuilder().addPort("output", this.format, this.outputCompression).create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block10: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "format": {
                    this.format = DataFormatRegistry.getInstance().getDataFormatFromName(p.getValue());
                    continue block10;
                }
                case "output.compression": {
                    this.outputCompression = CompressionType.valueOf((String)p.getValue());
                    continue block10;
                }
                case "output.compressions.allowed": {
                    this.outputCompressionsAllowed = CopyInputDataModule.decodeAllowedCompressionsParameterValue(p.getValue());
                    continue block10;
                }
            }
            Modules.unknownParameter(context, p);
        }
        if (this.format == null) {
            Modules.invalidConfiguration(context, "No format set");
        }
        if (this.outputCompression == null) {
            Modules.invalidConfiguration(context, "No output compression set");
        }
        if (this.outputCompressionsAllowed.isEmpty()) {
            throw new EoulsanException("output.compressions.allowed parameter value cannot be empty");
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            Data inData = context.getInputData("input");
            Data outData = context.getOutputData("output", inData);
            this.copyData(inData, outData, context);
            status.setProgress(1.0);
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }

    private static void checkFiles(DataFile inFile, DataFile outFile) throws IOException {
        if (inFile.equals(outFile)) {
            throw new IOException("Cannot copy file on itself: " + inFile);
        }
        if (!inFile.exists()) {
            throw new FileNotFoundException("Input file not found: " + inFile);
        }
        if (outFile.exists()) {
            throw new IOException("Output file already exists: " + outFile);
        }
    }

    private DataFile getRealDataFile(DataFile file) {
        try {
            DataProtocol protocol = file.getProtocol();
            if (protocol instanceof StorageDataProtocol) {
                return ((StorageDataProtocol)protocol).getUnderLyingData(file);
            }
            return file;
        }
        catch (IOException e) {
            return file;
        }
    }

    private void copyData(Data inData, Data outData, TaskContext context) throws IOException {
        if (inData.getFormat().getMaxFilesCount() == 1) {
            DataFile outputFile = this.copyFile(inData.getDataFile(), -1, outData.getName(), outData.getPart(), context);
            DataUtils.setDataFile(outData, outputFile);
        } else {
            int count = inData.getDataFileCount();
            ArrayList<DataFile> dataFiles = new ArrayList<DataFile>();
            for (int i = 0; i < count; ++i) {
                DataFile outputFile = this.copyFile(inData.getDataFile(i), i, outData.getName(), outData.getPart(), context);
                dataFiles.add(outputFile);
            }
            DataUtils.setDataFiles(outData, dataFiles);
        }
    }

    private DataFile copyFile(DataFile inputFile, int fileIndex, String outDataName, int outDataPart, TaskContext context) throws IOException {
        String stepId = context.getCurrentStep().getId();
        DataFile outputDir = context.getStepOutputDirectory();
        DataFile in = this.getRealDataFile(inputFile);
        CompressionType compression = this.getOutputCompressionType(in);
        String outFilename = FileNaming.filename(stepId, "output", this.format, outDataName, fileIndex, outDataPart, compression);
        DataFile out = new DataFile(outputDir, outFilename);
        CopyInputDataModule.checkFiles(in, out);
        DataFiles.symlinkOrCopy(in, out, true);
        return out;
    }

    private CompressionType getOutputCompressionType(DataFile inputFile) {
        CompressionType inCompression = inputFile.getCompressionType();
        if (this.outputCompressionsAllowed.contains(inCompression)) {
            return inCompression;
        }
        if (this.outputCompressionsAllowed.contains(CompressionType.NONE)) {
            return CompressionType.NONE;
        }
        return (CompressionType)this.outputCompressionsAllowed.iterator().next();
    }

    public static String encodeAllowedCompressionsParameterValue(EnumSet<CompressionType> outputCompressionAllowed) {
        if (outputCompressionAllowed == null) {
            return null;
        }
        return Joiner.on((char)'\t').join(outputCompressionAllowed);
    }

    private static EnumSet<CompressionType> decodeAllowedCompressionsParameterValue(String value) throws EoulsanException {
        if (value == null) {
            throw new EoulsanException("output.compressions.allowed parameter cannot be null");
        }
        HashSet<CompressionType> result = new HashSet<CompressionType>();
        for (String s : Splitter.on((char)'\t').omitEmptyStrings().trimResults().split((CharSequence)value)) {
            CompressionType compression = CompressionType.valueOf((String)s);
            if (compression == null) continue;
            result.add(compression);
        }
        return EnumSet.copyOf(result);
    }
}

