/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.NoLog;
import fr.ens.biologie.genomique.eoulsan.annotations.NoOutputDirectory;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.core.DataUtils;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

@LocalOnly
@ReuseModuleInstance
@NoLog
@NoOutputDirectory
public class CopyOutputDataModule
extends AbstractModule {
    public static final String MODULE_NAME = "_copyoutputformat";
    public static final String PORTS_PARAMETER = "ports";
    public static final String FORMATS_PARAMETER = "formats";
    private String portName;
    private DataFormat format;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return new InputPortsBuilder().addPort(this.portName, this.format).create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return new OutputPortsBuilder().addPort(this.portName, this.format).create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block8: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "formats": {
                    DataFormatRegistry registry = DataFormatRegistry.getInstance();
                    DataFormat format = registry.getDataFormatFromName(p.getValue());
                    if (format == null) {
                        Modules.badParameterValue(context, p, "Unknown format: " + p.getValue());
                    }
                    this.format = format;
                    continue block8;
                }
                case "ports": {
                    this.portName = p.getValue();
                    continue block8;
                }
            }
            Modules.unknownParameter(context, p);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            InputPorts inputPorts = context.getCurrentStep().getInputPorts();
            for (String portName : inputPorts.getPortNames()) {
                Data inData = context.getInputData(portName);
                Data outData = context.getOutputData(portName, inData);
                this.copyData(context, inData, outData);
                status.setProgress(1.0);
            }
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }

    private static void checkFiles(DataFile inFile, DataFile outFile) throws IOException {
        if (inFile.equals(outFile)) {
            throw new IOException("Cannot copy file on itself: " + inFile);
        }
        if (!inFile.exists()) {
            throw new FileNotFoundException("Input file not found: " + inFile);
        }
        if (outFile.exists()) {
            throw new IOException("Output file already exists: " + outFile);
        }
    }

    private void copyData(TaskContext context, Data inData, Data outData) throws IOException {
        DataFile outputDir = context.getStepOutputDirectory();
        if (inData.getFormat().getMaxFilesCount() == 1) {
            DataFile in = inData.getDataFile();
            DataFile out = new DataFile(outputDir, in.getName());
            CopyOutputDataModule.checkFiles(in, out);
            DataFiles.symlinkOrCopy(in, out, true);
            DataUtils.setDataFile(outData, out);
        } else {
            int count = inData.getDataFileCount();
            ArrayList<DataFile> outFiles = new ArrayList<DataFile>();
            for (int i = 0; i < count; ++i) {
                DataFile in = inData.getDataFile(i);
                DataFile out = new DataFile(outputDir, in.getName());
                outFiles.add(out);
                CopyOutputDataModule.checkFiles(in, out);
                DataFiles.symlinkOrCopy(in, out, true);
            }
            DataUtils.setDataFiles(outData, outFiles);
        }
    }
}

