/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.NoLog;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.core.DataUtils;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.core.OutputPort;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.ParallelizationMode;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.protocols.StorageDataProtocol;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.CheckerModule;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@ReuseModuleInstance
@NoLog
public class DesignModule
extends AbstractModule {
    public static final String MODULE_NAME = "design";
    private final Design design;
    private final CheckerModule checkerModule;
    private OutputPorts outputPorts;
    private final Set<String> designPortNames = new HashSet<String>();
    private final Set<String> samplePortNames = new HashSet<String>();

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public OutputPorts getOutputPorts() {
        return this.outputPorts;
    }

    @Override
    public ParallelizationMode getParallelizationMode() {
        return ParallelizationMode.NOT_NEEDED;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        Set<String> designMetadataKeys = this.design.getMetadata().keySet();
        HashSet sampleMetadataKeys = Sets.newHashSet(DesignUtils.getAllSamplesMetadataKeys(this.design));
        OutputPortsBuilder builder = new OutputPortsBuilder();
        for (DataFormat format : DataFormatRegistry.getInstance().getAllFormats()) {
            String key;
            if (designMetadataKeys.contains(format.getDesignMetadataKeyName())) {
                key = format.getDesignMetadataKeyName();
                builder.addPort(key, !format.isOneFilePerAnalysis(), format, this.compressionTypeOfDesignMetadata(key));
                this.designPortNames.add(key);
            }
            if (!sampleMetadataKeys.contains(format.getSampleMetadataKeyName())) continue;
            key = format.getSampleMetadataKeyName();
            builder.addPort(key, !format.isOneFilePerAnalysis(), format, this.compressionTypeOfField(key));
            this.samplePortNames.add(key);
        }
        this.outputPorts = builder.create();
        this.checkerModule.configureInputPorts(this.outputPorts);
    }

    private CompressionType compressionTypeOfField(String fieldname) {
        for (Sample sample : this.design.getSamples()) {
            DataFile file;
            CompressionType fileCompression;
            String fieldValue = sample.getMetadata().get(fieldname);
            if (fieldValue == null || (fileCompression = (file = new DataFile(fieldValue)).getCompressionType()) == CompressionType.NONE) continue;
            return fileCompression;
        }
        return CompressionType.NONE;
    }

    private CompressionType compressionTypeOfDesignMetadata(String key) {
        DataFile file;
        CompressionType fileCompression;
        String value = this.design.getMetadata().get(key);
        if (value != null && (fileCompression = (file = DesignModule.getUnderLyingDataFile(new DataFile(value))).getCompressionType()) != CompressionType.NONE) {
            return fileCompression;
        }
        return CompressionType.NONE;
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        HashSet<DataFile> files = new HashSet<DataFile>();
        HashSet<String> dataNames = new HashSet<String>();
        for (String portName : this.designPortNames) {
            OutputPort port = (OutputPort)this.getOutputPorts().getPort(portName);
            List<DataFile> dataFiles = this.getDesignDatafilesPort(this.design, port);
            DataFile f = dataFiles.get(0);
            if (files.contains(f)) continue;
            files.add(f);
            Data data = context.getOutputData(port.getName(), port.getName());
            if (port.getFormat().getMaxFilesCount() == 1) {
                DataUtils.setDataFile(data, f);
                continue;
            }
            DataUtils.setDataFiles(data, dataFiles);
        }
        for (Sample sample : this.design.getSamples()) {
            for (String portName : this.samplePortNames) {
                Data data;
                OutputPort port = (OutputPort)this.getOutputPorts().getPort(portName);
                List<DataFile> dataFiles = this.getSampleDatafilesPort(sample, port);
                DataFile f = dataFiles.get(0);
                if (files.contains(f)) continue;
                files.add(f);
                String dataListName = port.isList() || port.getFormat().getMaxFilesCount() > 1 ? port.getName() : Naming.toValidName(f.getBasename());
                Data dataList = context.getOutputData(port.getName(), dataListName);
                if (port.isList()) {
                    String dataName = Naming.toValidName(sample.getId());
                    if (dataNames.contains(dataName)) {
                        return status.createTaskResult(new EoulsanException("The design contains two or more sample with the same name after renaming: " + dataName + " ( original sample name: " + sample.getId() + ")"));
                    }
                    dataNames.add(dataName);
                    data = dataList.addDataToList(dataName);
                    DataUtils.setDataMetaData(data, sample);
                } else {
                    data = dataList;
                }
                if (port.getFormat().getMaxFilesCount() == 1) {
                    DataUtils.setDataFile(data, f);
                    continue;
                }
                DataUtils.setDataFiles(data, dataFiles);
                if (!DataFormats.READS_FASTQ.equals(port.getFormat()) || dataFiles.size() <= 1) continue;
                data.getMetadata().setPairedEnd(true);
            }
        }
        return status.createTaskResult();
    }

    private List<DataFile> getSampleDatafilesPort(Sample sample, OutputPort port) {
        Objects.requireNonNull(sample, "sample argument cannot be null");
        Objects.requireNonNull(port, "port argument cannot be null");
        ArrayList<DataFile> result = new ArrayList<DataFile>();
        String fieldName = null;
        for (String f : sample.getMetadata().keySet()) {
            if (!port.getName().equals(f.trim().toLowerCase())) continue;
            fieldName = f;
            break;
        }
        List<String> fieldValues = sample.getMetadata().getAsList(fieldName);
        for (String value : fieldValues) {
            result.add(new DataFile(value));
        }
        return result;
    }

    private List<DataFile> getDesignDatafilesPort(Design design, OutputPort port) {
        Objects.requireNonNull(design, "design argument cannot be null");
        Objects.requireNonNull(port, "port argument cannot be null");
        ArrayList<DataFile> result = new ArrayList<DataFile>();
        String fieldName = null;
        for (String f : design.getMetadata().keySet()) {
            if (!port.getName().equals(f.trim().toLowerCase())) continue;
            fieldName = f;
            break;
        }
        List<String> fieldValues = design.getMetadata().getAsList(fieldName);
        for (String value : fieldValues) {
            result.add(new DataFile(value));
        }
        return result;
    }

    private static DataFile getUnderLyingDataFile(DataFile file) {
        if (file == null) {
            return null;
        }
        try {
            DataProtocol protocol = file.getProtocol();
            if (protocol != null && protocol instanceof StorageDataProtocol) {
                return ((StorageDataProtocol)protocol).getUnderLyingData(file);
            }
        }
        catch (IOException e) {
            return file;
        }
        return file;
    }

    public DesignModule(Design design, CheckerModule checkeModule) {
        Objects.requireNonNull(design, "design argument cannot be null");
        Objects.requireNonNull(checkeModule, "checkerModule argument cannot be null");
        this.design = design;
        this.checkerModule = checkeModule;
    }
}

