/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.NoLog;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Set;

@LocalOnly
@ReuseModuleInstance
@NoLog
public class FailModule
extends AbstractModule {
    public static final String MODULE_NAME = "fail";
    private int delay = 0;
    private DataFormat inputFormat;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return this.inputFormat == null ? InputPortsBuilder.noInputPort() : InputPortsBuilder.singleInputPort(this.inputFormat);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block8: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "delay": {
                    this.delay = p.getIntValueGreaterOrEqualsTo(0);
                    continue block8;
                }
                case "input.format": {
                    this.inputFormat = DataFormatRegistry.getInstance().getDataFormatFromGalaxyFormatNameOrNameOrAlias(p.getLowerStringValue());
                    if (this.inputFormat != null) continue block8;
                    Modules.badParameterValue(context, p, "Unknown format");
                    continue block8;
                }
            }
            Modules.unknownParameter(context, p);
        }
        if (this.delay < 0) {
            Modules.invalidConfiguration(context, "Delay cannot be lower than 0: " + this.delay);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            Thread.sleep(this.delay * 1000);
        }
        catch (InterruptedException e) {
            context.getLogger().warning("Thread.sleep() interrupted: " + e.getMessage());
        }
        return status.createTaskResult(new EoulsanException("Fail of the step required by user"));
    }
}

