/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.galaxytools.GalaxyToolInterpreter;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolExecutorResult;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.DataToolElement;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.requirements.DockerRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

@LocalOnly
public class GalaxyToolModule
extends AbstractModule {
    private final GalaxyToolInterpreter toolInterpreter;
    private final String source;
    private final Set<Requirement> requirements = new HashSet<Requirement>();

    @Override
    public String getName() {
        return this.toolInterpreter.getToolInfo().getToolName();
    }

    @Override
    public Version getVersion() {
        return new Version(this.toolInterpreter.getToolInfo().getToolVersion());
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        for (DataToolElement element : this.toolInterpreter.getInputDataElements()) {
            builder.addPort(element.getValidatedName(), element.getDataFormat(), EnumSet.of(CompressionType.NONE), true);
        }
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        OutputPortsBuilder builder = new OutputPortsBuilder();
        for (DataToolElement element : this.toolInterpreter.getOutputDataElements()) {
            builder.addPort(element.getValidatedName(), element.getDataFormat());
        }
        return builder.create();
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.unmodifiableSet(this.requirements);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        this.toolInterpreter.configure(stepParameters);
        boolean dockerEnabled = EoulsanRuntime.getSettings().isDockerConnectionDefined();
        ToolInfo toolData = this.toolInterpreter.getToolInfo();
        if ("docker".equals(toolData.getInterpreter(dockerEnabled))) {
            this.requirements.add(DockerRequirement.newDockerRequirement(toolData.getDockerImage()));
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        ToolExecutorResult result;
        boolean dockerEnabled = context.getSettings().isDockerConnectionDefined();
        ToolInfo toolInfo = this.toolInterpreter.getToolInfo();
        context.getLogger().info("Launch tool galaxy " + toolInfo.getToolName() + ", version " + toolInfo.getToolVersion() + " with interpreter " + toolInfo.getInterpreter(dockerEnabled));
        try {
            result = this.toolInterpreter.execute(context);
        }
        catch (EoulsanException e) {
            return status.createTaskResult(e, "Error execution tool interpreter from building tool command line : " + e.getMessage());
        }
        status.setCommandLine(result.getCommandLineAsString());
        if (!result.isException()) {
            Throwable e = result.getException();
            return status.createTaskResult(e, "Error, execution interrupted: " + e.getMessage());
        }
        if (result.getExitValue() != 0) {
            return status.createTaskResult(null, "Fail execution of Galaxy tool with command: " + result.getCommandLine() + " Exit value: " + result.getExitValue());
        }
        return status.createTaskResult();
    }

    public String getSource() {
        return this.source;
    }

    public GalaxyToolModule(InputStream toolXMLis) throws EoulsanException {
        this(toolXMLis, null);
    }

    public GalaxyToolModule(InputStream in, String source) throws EoulsanException {
        if (in == null) {
            throw new NullPointerException("in argument cannot be null");
        }
        this.source = source == null ? "Undefined source" : source.trim();
        this.toolInterpreter = new GalaxyToolInterpreter(in, this.source);
    }
}

