/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.core.DataUtils;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Merger;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@LocalOnly
@ReuseModuleInstance
public class MergerModule
extends AbstractModule {
    public static final String MODULE_NAME = "merger";
    private Merger merger;
    private CompressionType compression = CompressionType.NONE;

    protected String getMapKey(Data data) {
        return data.getName();
    }

    protected boolean checkForPartDuplicates() {
        return true;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return new InputPortsBuilder().addPort("input", true, this.merger.getFormat()).create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return new OutputPortsBuilder().addPort("output", true, this.merger.getFormat(), this.compression).create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        HashSet<Parameter> mergerParameters = new HashSet<Parameter>();
        block8: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "format": {
                    DataFormat format = DataFormatRegistry.getInstance().getDataFormatFromNameOrAlias(p.getValue());
                    if (format == null) {
                        Modules.badParameterValue(context, p, "Unknown format: " + p.getValue());
                    }
                    if (!format.isMerger()) {
                        Modules.badParameterValue(context, p, "No splitter exists for format: " + format.getName());
                    }
                    this.merger = format.getMerger();
                    continue block8;
                }
                case "compression": {
                    this.compression = CompressionType.getCompressionTypeByContentEncoding((String)p.getValue());
                    continue block8;
                }
            }
            mergerParameters.add(p);
        }
        if (this.merger == null) {
            Modules.invalidConfiguration(context, "No format set for merge");
        }
        this.merger.configure(mergerParameters);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        DataFormat format = this.merger.getFormat();
        Data inListData = context.getInputData(format);
        Data outListData = context.getOutputData(format, inListData);
        try {
            MergerIterator it = new MergerIterator(inListData);
            for (String dataName : it.getDataNames()) {
                Data outData = outListData.addDataToList(Naming.toValidName(dataName));
                DataUtils.setDataMetadata(outData, it.getListData(dataName));
                if (format.getMaxFilesCount() == 1) {
                    DataFile outFile = outData.getDataFile();
                    this.merger.merge(it.getIterator(dataName), outFile);
                    continue;
                }
                for (int fileIndex = 0; fileIndex < it.getMaxFileIndex(); ++fileIndex) {
                    DataFile outFile = outData.getDataFile(fileIndex);
                    this.merger.merge(it.getIterator(dataName, fileIndex), outFile);
                }
            }
            return status.createTaskResult();
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e);
        }
    }

    private final class MergerIterator {
        private final ListMultimap<String, Data> map = ArrayListMultimap.create();
        private int maxFileIndex = 1;

        public Set<String> getDataNames() {
            return this.map.keySet();
        }

        public List<Data> getListData(String dataName) {
            return this.map.get((Object)dataName);
        }

        public int getMaxFileIndex() {
            return this.maxFileIndex;
        }

        public Iterator<DataFile> getIterator(String dataName) throws EoulsanException {
            return this.getIterator(dataName, -1);
        }

        public Iterator<DataFile> getIterator(String dataName, final int fileIndex) throws EoulsanException {
            ArrayList list = Lists.newArrayList((Iterable)this.map.get((Object)dataName));
            list.sort(Comparator.comparingInt(Data::getPart));
            if (MergerModule.this.checkForPartDuplicates()) {
                HashSet<Integer> partNumbers = new HashSet<Integer>();
                for (Data data : list) {
                    if (partNumbers.contains(data.getPart())) {
                        throw new EoulsanException("Found two or more data with the same part: " + data.getName());
                    }
                    partNumbers.add(data.getPart());
                }
            }
            final Iterator it = list.iterator();
            return new Iterator<DataFile>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public DataFile next() {
                    if (fileIndex == -1) {
                        return ((Data)it.next()).getDataFile();
                    }
                    return ((Data)it.next()).getDataFile(fileIndex);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private void checkKeys() throws EoulsanException {
            HashSet<String> validNames = new HashSet<String>();
            for (String name : this.getDataNames()) {
                String validName = Naming.toValidName(name);
                if (validNames.contains(validName)) {
                    throw new EoulsanException("Two merger keys share the same data name (" + name + " -> " + validName + ")");
                }
                validNames.add(validName);
            }
        }

        public MergerIterator(Data data) throws EoulsanException {
            for (Data d : data.getListElements()) {
                String key = MergerModule.this.getMapKey(d);
                if (key == null) continue;
                this.map.put((Object)key, (Object)d);
                if (d.getDataFileCount() <= this.maxFileIndex) continue;
                this.maxFileIndex = d.getDataFileCount();
            }
            this.checkKeys();
        }
    }
}

