/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.ParallelizationMode;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.requirements.RequirementService;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Set;

@LocalOnly
public class RequirementInstallerModule
extends AbstractModule {
    public static final String MODULE_NAME = "requirementinstaller";
    private Requirement requirement;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public ParallelizationMode getParallelizationMode() {
        return ParallelizationMode.NOT_NEEDED;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        String requirementName = null;
        for (Parameter p : stepParameters) {
            if (!"name".equals(p.getName())) continue;
            requirementName = p.getValue();
        }
        this.requirement = (Requirement)RequirementService.getInstance().newService(requirementName);
        if (this.requirement == null) {
            Modules.invalidConfiguration(context, "Unknown requirement: " + requirementName);
        }
        this.requirement.configure(stepParameters);
        if (!this.requirement.isInstallable()) {
            Modules.invalidConfiguration(context, "The requirement is not installable: " + requirementName);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            this.requirement.install(status);
        }
        catch (EoulsanException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }
}

