/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.DataMetadata;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Splitter;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@LocalOnly
@ReuseModuleInstance
public class SplitterModule
extends AbstractModule {
    public static final String MODULE_NAME = "splitter";
    private Splitter splitter;
    private CompressionType compression = CompressionType.NONE;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(this.splitter.getFormat());
    }

    @Override
    public OutputPorts getOutputPorts() {
        return new OutputPortsBuilder().addPort("output", true, this.splitter.getFormat(), this.compression).create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        HashSet<Parameter> splitterParameters = new HashSet<Parameter>();
        block8: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "format": {
                    DataFormat format = DataFormatRegistry.getInstance().getDataFormatFromNameOrAlias(p.getValue());
                    if (format == null) {
                        Modules.badParameterValue(context, p, "Unknown format: " + p.getValue());
                    }
                    if (!format.isSplitter()) {
                        Modules.badParameterValue(context, p, "No splitter exists for format: " + format.getName());
                    }
                    this.splitter = format.getSplitter();
                    continue block8;
                }
                case "compression": {
                    this.compression = CompressionType.getCompressionTypeByContentEncoding((String)p.getValue());
                    continue block8;
                }
            }
            splitterParameters.add(p);
        }
        if (this.splitter == null) {
            Modules.invalidConfiguration(context, "No format set for splitter");
        }
        this.splitter.configure(splitterParameters);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        DataFormat format = this.splitter.getFormat();
        Data inData = context.getInputData(format);
        Data outData = context.getOutputData(format, inData);
        DataMetadata metadata = inData.getMetadata();
        try {
            if (inData.getPart() != -1) {
                throw new EoulsanException("Cannot split already split data");
            }
            if (format.getMaxFilesCount() == 1) {
                this.splitter.split(inData.getDataFile(), new SplitterIterator(outData, metadata).getIterator());
            } else {
                SplitterIterator iterator = new SplitterIterator(outData, metadata);
                for (int fileIndex = 0; fileIndex < inData.getDataFileCount(); ++fileIndex) {
                    this.splitter.split(inData.getDataFile(fileIndex), iterator.getIterator(fileIndex));
                }
            }
            return status.createTaskResult();
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e);
        }
    }

    private static final class SplitterIterator {
        private final Data data;
        private final DataMetadata metadata;
        private final List<Data> list = new ArrayList<Data>();

        private Data getData(int index) {
            Preconditions.checkState((index <= this.list.size() ? 1 : 0) != 0, (Object)("invalid index: " + index + " (maximum expected index: " + this.list.size() + ")"));
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index argument cannot be lower than 0");
            if (index == this.list.size()) {
                Data newData = this.data.addDataToList(this.data.getName(), index);
                newData.getMetadata().set(this.metadata);
                this.list.add(newData);
            }
            return this.list.get(index);
        }

        Iterator<DataFile> getIterator() {
            return this.getIterator(-1);
        }

        Iterator<DataFile> getIterator(final int fileIndex) {
            Preconditions.checkArgument((fileIndex >= -1 ? 1 : 0) != 0, (Object)"fileIndex argument cannot be lower than -1");
            return new Iterator<DataFile>(){
                final Map<Integer, Integer> counts = new HashMap<Integer, Integer>();

                private int incrCount() {
                    if (!this.counts.containsKey(fileIndex)) {
                        this.counts.put(fileIndex, 0);
                    }
                    int result = this.counts.get(fileIndex);
                    this.counts.put(fileIndex, result + 1);
                    return result;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public DataFile next() {
                    Data d = this.getData(this.incrCount());
                    if (fileIndex == -1) {
                        return d.getDataFile();
                    }
                    return d.getDataFile(fileIndex);
                }
            };
        }

        public SplitterIterator(Data data, DataMetadata metadata) {
            this.data = data;
            this.metadata = metadata;
        }
    }
}

