/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq.peakcalling;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.chipseq.ChIPSeqDataFormats;
import fr.ens.biologie.genomique.eoulsan.requirements.DockerRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanDockerManager;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@LocalOnly
public class BedToolsModule
extends AbstractModule {
    private static final String MODULE_NAME = "bedtools";
    private static final String BEDTOOLS_DEFAULT_DOCKER_IMAGE = "genomicpariscentre/bedtools:latest";
    private Requirement requirement;
    private String dockerImage = "genomicpariscentre/bedtools:latest";

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "This step runs a tool from the BEDTools suite.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("inputlist", true, ChIPSeqDataFormats.PEAK);
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        OutputPortsBuilder builder = new OutputPortsBuilder();
        builder.addPort("outputlist", true, ChIPSeqDataFormats.PEAK);
        return builder.create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block6: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "docker.image": {
                    this.dockerImage = p.getStringValue().trim();
                    if (!this.dockerImage.isEmpty()) continue block6;
                    Modules.badParameterValue(context, p, "The docker image name is empty");
                    continue block6;
                }
            }
            Modules.unknownParameter(context, p);
        }
        this.requirement = DockerRequirement.newDockerRequirement(this.dockerImage, true);
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.singleton(this.requirement);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data inData = context.getInputData(ChIPSeqDataFormats.PEAK);
        Design design = context.getWorkflow().getDesign();
        int count = 1;
        HashMap<String, Data> nameMap = new HashMap<String, Data>();
        for (Data data : inData.getListElements()) {
            String name = data.getMetadata().getSampleName();
            nameMap.put(name, data);
            EoulsanLogger.getLogger().info(count + " Sample name: " + name);
            ++count;
        }
        HashMap expMap = new HashMap();
        for (Experiment e : design.getExperiments()) {
            for (ExperimentSample expSam : e.getExperimentSamples()) {
                EoulsanLogger.getLogger().info("Input file. ref : " + DesignUtils.getReference(expSam) + "| exp : " + e.getName() + "| rep : " + DesignUtils.getRepTechGroup(expSam));
                boolean isReference = DesignUtils.getReference(expSam).toLowerCase().equals("true");
                if (isReference) {
                    EoulsanLogger.getLogger().info("Reference file, not treated.");
                    continue;
                }
                EoulsanLogger.getLogger().info("Not a reference file. Proceeding.");
                String sortingKey = e.getName();
                if (expMap.get(sortingKey) == null) {
                    ArrayList<Data> tmpList = new ArrayList<Data>();
                    tmpList.add((Data)nameMap.get(expSam.getSample().getName()));
                    expMap.put(sortingKey, tmpList);
                } else {
                    ((List)expMap.get(sortingKey)).add((Data)nameMap.get(expSam.getSample().getName()));
                }
                EoulsanLogger.getLogger().info("Now " + ((List)expMap.get(sortingKey)).size() + " samples for experiment " + sortingKey);
            }
        }
        Data data = context.getOutputData(ChIPSeqDataFormats.PEAK, "mergedPeaklist");
        for (String experimentName : expMap.keySet()) {
            List expDataList = (List)expMap.get(experimentName);
            ArrayList<Data> expDataList2 = new ArrayList<Data>();
            for (int i = 0; i < expDataList.size(); ++i) {
                EoulsanLogger.getLogger().info("for " + experimentName + " Data " + i + " : " + expDataList.get(i));
                if (expDataList.get(i) == null) continue;
                expDataList2.add((Data)expDataList.get(i));
            }
            for (int j = 0; j < expDataList2.size(); ++j) {
                EoulsanLogger.getLogger().info("expDataList2; for " + experimentName + " Data " + j + " : " + expDataList2.get(j));
            }
            EoulsanLogger.getLogger().info("File count for " + experimentName + " : " + expDataList2.size());
            if (expDataList.size() < 2) {
                EoulsanLogger.getLogger().info("Data list contains only 1 sample for experiment " + experimentName);
                Data anInputData = (Data)expDataList2.get(0);
                Data outputData = data.addDataToList(anInputData.getMetadata().getSampleName().replaceAll("[^a-zA-Z0-9]", ""));
                outputData.getMetadata().set(anInputData.getMetadata());
                try {
                    anInputData.getDataFile().symlink(outputData.getDataFile());
                    continue;
                }
                catch (IOException ioe) {
                    EoulsanLogger.getLogger().severe("Could not create symlink from " + anInputData.getDataFile() + " to " + outputData.getDataFile());
                    return status.createTaskResult();
                }
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(MODULE_NAME);
            cmd.add("multiinter");
            cmd.add("-i");
            for (Data sample : expDataList2) {
                cmd.add(String.format("%s", sample.getDataFilename()));
            }
            DataMetadata metadata = ((Data)expDataList2.get(0)).getMetadata();
            EoulsanLogger.getLogger().info("Test metadata " + metadata.getSampleName());
            Data peakData = data.addDataToList(metadata.getSampleName().replaceAll("[^a-zA-Z0-9]", "") + "Mergedpeaks");
            peakData.getMetadata().set(metadata);
            File outputFile = peakData.getDataFile().toFile();
            File stderrFile = new File("docker.err");
            String cmd2 = Joiner.on((char)' ').join(cmd);
            EoulsanLogger.getLogger().info("Run command line : " + cmd2);
            try {
                DockerImageInstance process = EoulsanDockerManager.getInstance().createImageInstance(this.dockerImage);
                int exitValue = process.execute(cmd, context.getStepOutputDirectory().toFile(), context.getLocalTempDirectory(), outputFile, stderrFile, new File[0]);
                ProcessUtils.throwExitCodeException(exitValue, Joiner.on((char)' ').join(cmd));
            }
            catch (IOException err) {
                return status.createTaskResult(err);
            }
        }
        return status.createTaskResult();
    }
}

