/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq.peakcalling;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.chipseq.ChIPSeqDataFormats;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

@LocalOnly
public class MergePeaksModule
extends AbstractModule {
    @Override
    public String getName() {
        return "mergepeaks";
    }

    @Override
    public String getDescription() {
        return "This step concatenante all the peaks files of each RepTechGroup.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("inputpeaklists", true, ChIPSeqDataFormats.PEAK);
        return builder.create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) {
        if (!stepParameters.isEmpty()) {
            EoulsanLogger.getLogger().warning("MergePeaks accepts no parameters. Ignored.");
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data inData = context.getInputData(ChIPSeqDataFormats.PEAK);
        HashMap expMap = new HashMap(inData.getListElements().size() / 2);
        for (Data anInputData : inData.getListElements()) {
            EoulsanLogger.getLogger().finest("Input file. ref : " + anInputData.getMetadata().get("Reference") + "| exp : " + anInputData.getMetadata().get("Experiment") + "| rep : " + anInputData.getMetadata().get("RepTechGroup"));
            boolean isReference = anInputData.getMetadata().get("Reference").toLowerCase().equals("true");
            if (isReference) {
                EoulsanLogger.getLogger().finest("Reference file, not treated.");
                continue;
            }
            EoulsanLogger.getLogger().finest("Not a reference file. Proceeding.");
            String experimentName = anInputData.getMetadata().get("Experiment");
            String replicateGroupName = anInputData.getMetadata().get("RepTechGroup");
            String sortingKey = experimentName + (String)replicateGroupName;
            if (expMap.get(sortingKey) == null) {
                ArrayList<Data> tmpList = new ArrayList<Data>();
                tmpList.add(anInputData);
                expMap.put((CallSite)((Object)sortingKey), tmpList);
            } else {
                ((ArrayList)expMap.get(sortingKey)).add(anInputData);
            }
            EoulsanLogger.getLogger().finest("Now " + ((ArrayList)expMap.get(sortingKey)).size() + " samples for experiment/replicate " + sortingKey);
        }
        for (String experimentName : expMap.keySet()) {
            ArrayList expDataList = (ArrayList)expMap.get(experimentName);
            if (expDataList.size() < 2) continue;
            StringBuilder cmd = new StringBuilder("cat");
            for (Data sample : expDataList) {
                cmd.append(String.format(" %s", sample.getDataFile().getSource()));
            }
            try {
                File outputFile = new File(String.format("%s/mergedpeaks_output_%s.bed", ((Data)expDataList.get(0)).getDataFile().getParent().getSource(), experimentName));
                EoulsanLogger.getLogger().info(String.format("Running : %s with output: %s", cmd.toString(), outputFile));
                ProcessUtils.execWriteOutput(cmd.toString(), outputFile);
            }
            catch (IOException e) {
                EoulsanLogger.getLogger().severe(e.toString());
            }
        }
        return status.createTaskResult();
    }
}

