/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq.qc;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.kenetre.util.BinariesInstaller;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@LocalOnly
public class IDRModule
extends AbstractModule {
    private static final String TOOL_NAME = "IDR";
    private static final String SHIPPED_PACKAGE_VERSION = "20120922_patched";
    private static final String PACKAGE_ARCHIVE = "idrCode_20120922_patched.tar.gz";
    private static final DataFormat PEAK = DataFormatRegistry.getInstance().getDataFormatFromName("peaks");
    private static final List<String> ACCEPTED_ASSEMBLIES = Arrays.asList("human.hg19", "human.hg18", "mm9", "worm.ws220");
    private static final Map<String, String> ACCEPTED_ASSEMBLIES_FILES;
    private int peakHalfWidth = -1;
    private int minOverlapRatio = 0;
    private boolean isBroadpeak = false;
    private String rankingMeasure = "p.value";
    private String assembly = "human.hg19";
    private String idrPath = "";

    @Override
    public String getName() {
        return "idr";
    }

    @Override
    public String getDescription() {
        return "This step performs a quality control using IDR algorithm, as implemented by idrCode (https://sites.google.com/site/anshulkundaje/projects/idr).";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("inputpeaklists", true, PEAK);
        return builder.create();
    }

    private void install() {
        try {
            BinariesInstaller installer = new BinariesInstaller("Eoulsan", Globals.APP_VERSION_STRING);
            String binaryFile = installer.install(TOOL_NAME, SHIPPED_PACKAGE_VERSION, PACKAGE_ARCHIVE, EoulsanRuntime.getSettings().getTempDirectoryFile().getAbsolutePath());
            EoulsanLogger.getLogger().info("Archive location : " + binaryFile);
            DataFile idrArchive = new DataFile(binaryFile);
            this.idrPath = idrArchive.getParent().getSource();
            String cmd = String.format("tar -xzf %s -C %s", idrArchive.getSource(), this.idrPath);
            EoulsanLogger.getLogger().info("Unpacking archive : " + cmd);
            ProcessUtils.exec(cmd, false);
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().warning("Error during IDR file installation : " + e.toString());
        }
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        for (Parameter p : stepParameters) {
            EoulsanLogger.getLogger().info("IDR parameter: " + p.getName() + " : " + p.getStringValue());
            if ("min.overlap.ratio".equals(p.getName())) {
                this.minOverlapRatio = p.getIntValue();
                continue;
            }
            if ("peak.half.width".equals(p.getName())) {
                EoulsanLogger.getLogger().warning("As written in IDR documentation, concerning parameter peak.half.width :\nIMPORTANT: Currrently this parameter does not work properly so please pre-truncate your peaks if desired before feeding to IDR. Always set this parameter to -1.\nSee https://sites.google.com/site/anshulkundaje/projects/idr#TOC-IDR-CODE-README or IDR's README file.");
                continue;
            }
            if ("is.broadpeak".equals(p.getName())) {
                this.isBroadpeak = p.getBooleanValue();
                continue;
            }
            if ("ranking.measure".equals(p.getName())) {
                String tmpRanking = p.getStringValue();
                if ("signal.value".equals(tmpRanking) || "p.value".equals(tmpRanking) || "q.value".equals(tmpRanking)) {
                    this.rankingMeasure = tmpRanking;
                    continue;
                }
                throw new EoulsanException("Unknown value (" + p.getStringValue() + ") for ranking.measure parameter (step: " + this.getName() + ").");
            }
            if ("assembly".equals(p.getName())) {
                if (ACCEPTED_ASSEMBLIES.contains(p.getStringValue())) {
                    this.assembly = p.getStringValue();
                    continue;
                }
                throw new EoulsanException("Unknow value for 'assembly' parameter (IDR step) : " + p.getStringValue());
            }
            throw new EoulsanException("Unknown parameter for " + this.getName() + " step: " + p.getName());
        }
        if (this.assembly.equals("")) {
            EoulsanLogger.getLogger().warning("No assembly specified. Will use human genome (version 19) by default");
        }
        this.install();
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data inData = context.getInputData(PEAK);
        if (!inData.isList() || inData.getListElements().size() < 2) {
            EoulsanLogger.getLogger().severe("Not enough data to run IDR. Need a list of at least two samples.");
            return status.createTaskResult();
        }
        HashMap expMap = new HashMap(inData.getListElements().size() / 2);
        for (Data anInputData : inData.getListElements()) {
            EoulsanLogger.getLogger().info("One input file. ref : " + anInputData.getMetadata().get("Reference") + "| exp : " + anInputData.getMetadata().get("Experiment") + "| rep : " + anInputData.getMetadata().get("RepTechGroup"));
            boolean isReference = anInputData.getMetadata().get("Reference").toLowerCase().equals("true");
            String experimentName = anInputData.getMetadata().get("Experiment");
            if (isReference) {
                EoulsanLogger.getLogger().info("Reference file, not treated.");
                continue;
            }
            EoulsanLogger.getLogger().info("Not a reference file. Proceeding.");
            if (expMap.get(experimentName) == null) {
                ArrayList<Data> tmpList = new ArrayList<Data>();
                tmpList.add(anInputData);
                expMap.put(experimentName, tmpList);
            } else {
                ((ArrayList)expMap.get(experimentName)).add(anInputData);
            }
            EoulsanLogger.getLogger().info("Now " + ((ArrayList)expMap.get(experimentName)).size() + " samples for experiment " + experimentName);
        }
        for (String experimentName : expMap.keySet()) {
            ArrayList expDataList = (ArrayList)expMap.get(experimentName);
            HashMap replicatesMap = new HashMap(expDataList.size() / 2);
            for (Data data : expDataList) {
                String replicateGroupName = data.getMetadata().get("RepTechGroup");
                if (replicatesMap.get(replicateGroupName) == null) {
                    ArrayList<Data> tmpList = new ArrayList<Data>();
                    tmpList.add(data);
                    replicatesMap.put(replicateGroupName, tmpList);
                    continue;
                }
                ((ArrayList)replicatesMap.get(replicateGroupName)).add(data);
            }
            for (Map.Entry entry : replicatesMap.entrySet()) {
                int nbSameReplicates;
                ArrayList replicatesList = (ArrayList)entry.getValue();
                if (replicatesList == null || replicatesList.size() == 0) {
                    EoulsanLogger.getLogger().severe("Incoherence : experiment " + (String)entry.getKey() + " has no corresponding sample.");
                }
                if ((nbSameReplicates = replicatesList.size()) == 1) {
                    Data tmp = (Data)replicatesList.get(0);
                    EoulsanLogger.getLogger().info("Will not call IDR on 1 sample, for experiment " + tmp.getMetadata().get("Experiment") + " in replicate group " + tmp.getMetadata().get("RepTechGroup"));
                    continue;
                }
                String outputDir = "";
                try {
                    outputDir = ((Data)replicatesList.get(0)).getDataFile().getParent().getSource();
                }
                catch (IOException e) {
                    EoulsanLogger.getLogger().severe("Error while accessing parent folder of " + ((Data)replicatesList.get(0)).getDataFile().getSource() + ". " + e.toString());
                }
                ArrayList<String> outputs = new ArrayList<String>();
                for (int i = 0; i < nbSameReplicates; ++i) {
                    for (int j = i + 1; j < nbSameReplicates; ++j) {
                        int retVal = this.runAnalysis((Data)replicatesList.get(i), (Data)replicatesList.get(j));
                        if (retVal != 0) continue;
                        outputs.add(String.format("%s/idr_output_%s_vs_%s", outputDir, ((Data)replicatesList.get(i)).getMetadata().get("Name"), ((Data)replicatesList.get(j)).getMetadata().get("Name")));
                    }
                }
                if (outputs.size() <= 1) continue;
                this.runAnalysisPlot(outputs.size(), String.format("%s/idrplot_output_%s", outputDir, entry.getKey()), outputs);
            }
        }
        return status.createTaskResult();
    }

    private int runAnalysis(Data data1, Data data2) {
        if (!data1.getDataFile().exists()) {
            EoulsanLogger.getLogger().severe("File " + data1.getDataFile().getSource() + " doesn't exist.");
            return -1;
        }
        if (!data2.getDataFile().exists()) {
            EoulsanLogger.getLogger().severe("File " + data2.getDataFile().getSource() + " doesn't exist.");
            return -1;
        }
        String outputDir = "";
        try {
            outputDir = data1.getDataFile().getParent().getSource();
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe("Error while accessing parent folder of " + data1.getDataFile().getSource() + ". " + e.toString());
            return -1;
        }
        String inputPrefix = String.format("idr_output_%s_vs_%s", data1.getMetadata().get("Name"), data2.getMetadata().get("Name"));
        String cmd = String.format("cd %s/idrCode/ ; Rscript %s/batch-consistency-analysis.r %s %s %d %s/%s %d %s %s %s; cd -", this.idrPath, ".", data1.getDataFile().getSource(), data2.getDataFile().getSource(), this.peakHalfWidth, outputDir, inputPrefix, this.minOverlapRatio, this.isBroadpeak ? "T" : "F", this.rankingMeasure, ACCEPTED_ASSEMBLIES_FILES.get(this.assembly));
        EoulsanLogger.getLogger().info("Running : " + cmd);
        String outputStr = "";
        try {
            outputStr = ProcessUtils.execToString(cmd);
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe(e.toString());
            EoulsanLogger.getLogger().severe("\nException while running IDR:\n" + outputStr);
            return -1;
        }
        String outputPrefix = String.format("idrplot_output_%s_vs_%s", data1.getMetadata().get("Name"), data2.getMetadata().get("Name"));
        return this.runAnalysisPlot(1, String.format("%s/%s", outputDir, outputPrefix), Collections.singletonList(String.format("%s/%s", outputDir, inputPrefix)));
    }

    private int runAnalysisPlot(int nbPairs, String outputPrefix, Iterable<String> inputPrefixIter) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        String separator = " ";
        for (String s : inputPrefixIter) {
            sb.append(sep).append(s);
            sep = separator;
        }
        String cmd = String.format("cd %s/idrCode/ ; Rscript %s/batch-consistency-plot.r %d %s %s; cd -", this.idrPath, ".", nbPairs, outputPrefix, sb.toString());
        EoulsanLogger.getLogger().info("Running : " + cmd);
        String outputStr = "";
        try {
            outputStr = ProcessUtils.execToString(cmd);
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().warning("Exception while running IDR plot:\n" + e.toString() + "\nOutput string:\n" + outputStr);
            return -1;
        }
        return 0;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>(4);
        tempMap.put("human.hg19", "./genome_tables/genome_table.human.hg19.txt");
        tempMap.put("human.hg18", "./genome_tables/genome_table.human.hg18.txt");
        tempMap.put("mm9", "./genome_tables/genome_table.mm9.txt");
        tempMap.put("worm.ws220", "./genome_tables/genome_table.worm.ws220.txt");
        ACCEPTED_ASSEMBLIES_FILES = Collections.unmodifiableMap(tempMap);
    }
}

