/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.diffana;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.checkers.DESeq2DesignChecker;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentMetadata;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSampleMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.SampleMetadata;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DESeq2 {
    private static final String SCRIPTS_PATH_IN_JAR_FILE = "/DESeq2/";
    private static final String NORM_DIFFANA_SCRIPT = "normDiffana.R";
    private static final String BUILD_CONTRAST_SCRIPT = "buildContrast.R";
    private static final String DESEQ_DESIGN_FILE_SUFFIX = "-deseq2Design.txt";
    private static final String COMPARISON_FILE_SUFFIX = "-comparisonFile.txt";
    private static final String CONTRAST_FILE_SUFFIX = "-contrastFile.txt";
    private static final String SAMPLE_ID_FIELDNAME = "SampleId";
    private static final String SAMPLE_NAME_FIELDNAME = "Name";
    private static final String EXPRESSION_FILE_FIELDNAME = "expressionFile";
    private static final String TAB_SEPARATOR = "\t";
    private static final String NEWLINE = "\n";
    private final Experiment experiment;
    final Map<String, File> sampleFiles;
    private final Design design;
    private final boolean normFig;
    private final boolean diffanaFig;
    private final boolean normDiffana;
    private final boolean diffana;
    private final SizeFactorsType sizeFactorsType;
    private final FitType fitType;
    private final StatisticTest statisticTest;
    private final String model;
    private final boolean contrast;
    private final boolean buildContrast;
    private final DataFile contrastFile;
    private final boolean expHeader = true;
    private final RExecutor executor;
    private final boolean saveRScripts;
    private final String stepId;
    private final Map<String, String> sampleFilenames = new HashMap<String, String>();

    private void putSampleFiles() throws IOException {
        for (Sample sample : this.experiment.getSamples()) {
            if (!this.sampleFiles.containsKey(sample.getId())) continue;
            String key = sample.getId();
            DataFile inputFile = new DataFile(this.sampleFiles.get(key).getAbsolutePath());
            String outputFilename = "expression-" + key + ".tsv";
            this.executor.putInputFile(inputFile, outputFilename);
            this.sampleFilenames.put(key, outputFilename);
        }
    }

    private String generateDeseq2Design() {
        StringBuilder sb = new StringBuilder();
        sb.append(SAMPLE_ID_FIELDNAME);
        sb.append(TAB_SEPARATOR);
        sb.append(SAMPLE_NAME_FIELDNAME);
        sb.append(TAB_SEPARATOR);
        sb.append(EXPRESSION_FILE_FIELDNAME);
        List<String> sampleMDKeys = DesignUtils.getAllSamplesMetadataKeys(this.design);
        List<String> experimentMDKeys = DesignUtils.getExperimentSampleAllMetadataKeys(this.experiment);
        String experimentReference = this.experiment.getMetadata().getReference();
        boolean referenceColumn = experimentReference != null || sampleMDKeys.contains("Reference") || experimentMDKeys.contains("Reference");
        for (String key : sampleMDKeys) {
            if (experimentMDKeys.contains(key) || "Reference".equals(key)) continue;
            sb.append(TAB_SEPARATOR);
            sb.append(key);
        }
        for (String key : experimentMDKeys) {
            if ("Reference".equals(key)) continue;
            sb.append(TAB_SEPARATOR);
            sb.append(key);
        }
        if (referenceColumn) {
            sb.append(TAB_SEPARATOR);
            sb.append("Reference");
        }
        sb.append(NEWLINE);
        for (Sample sample : this.experiment.getSamples()) {
            if (!this.sampleFilenames.containsKey(sample.getId())) continue;
            sb.append(sample.getId());
            sb.append(TAB_SEPARATOR);
            sb.append(sample.getName());
            sb.append(TAB_SEPARATOR);
            sb.append(this.sampleFilenames.get(sample.getId()));
            SampleMetadata smd = sample.getMetadata();
            for (String key : sampleMDKeys) {
                if (experimentMDKeys.contains(key) || "Reference".equals(key)) continue;
                sb.append(TAB_SEPARATOR);
                if (!smd.contains(key)) continue;
                sb.append(smd.get(key));
            }
            ExperimentSample es = this.experiment.getExperimentSample(sample);
            ExperimentSampleMetadata expSampleMetadata = es.getMetadata();
            for (String key : experimentMDKeys) {
                if ("Reference".equals(key)) continue;
                sb.append(TAB_SEPARATOR);
                if (!expSampleMetadata.contains(key)) continue;
                sb.append(expSampleMetadata.get(key));
            }
            if (referenceColumn) {
                sb.append(TAB_SEPARATOR);
                sb.append(DesignUtils.referenceValueToInt(DesignUtils.getReference(es), experimentReference));
            }
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private String generateComparisonFileContent() throws EoulsanException {
        StringBuilder sb = new StringBuilder();
        for (String c : this.experiment.getMetadata().getComparisons().split(";")) {
            String[] splitC = c.split(":");
            if (splitC.length != 2) {
                throw new EoulsanException("Invalid comparison entry format: " + c);
            }
            sb.append(splitC[0].trim());
            sb.append(TAB_SEPARATOR);
            sb.append(splitC[1].trim());
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private String[] createNormDiffanaCommandLine(String deseq2DesignFileName, String contrastFilename) {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(DESeq2.booleanParameter(this.normFig), DESeq2.booleanParameter(this.diffana), DESeq2.booleanParameter(this.diffanaFig)));
        if (this.contrast) {
            command.add(DESeq2.booleanParameter(this.contrast));
        } else {
            command.add(DESeq2.booleanParameter(false));
        }
        command.addAll(Arrays.asList(deseq2DesignFileName, this.model, this.experiment.getName(), DESeq2.booleanParameter(this.expHeader), this.sizeFactorsType.toDESeq2Value(), this.fitType.toDESeq2Value(), this.statisticTest.toDESeq2Value(), contrastFilename, this.stepId + "_"));
        return command.toArray(new String[0]);
    }

    private static String booleanParameter(boolean value) {
        return Boolean.valueOf(value).toString().toUpperCase();
    }

    public void runDEseq2(DataFile workflowOutputDir) throws IOException, EoulsanException {
        String description;
        String prefix = this.stepId + "_" + this.experiment.getName();
        String deseq2DesignFileName = prefix + DESEQ_DESIGN_FILE_SUFFIX;
        String comparisonFileName = prefix + COMPARISON_FILE_SUFFIX;
        String contrastFilename = prefix + CONTRAST_FILE_SUFFIX;
        DESeq2DesignChecker.checkExperimentDesign(this.experiment);
        this.executor.openConnection();
        this.putSampleFiles();
        this.executor.writerFile(this.generateDeseq2Design(), deseq2DesignFileName);
        if (this.contrastFile != null) {
            this.executor.putInputFile(this.contrastFile, contrastFilename);
        }
        if (this.buildContrast) {
            if (!this.experiment.getMetadata().containsComparisons()) {
                throw new EoulsanException("No comparison defined to build the constrasts in experiment: " + this.experiment.getName());
            }
            this.executor.writerFile(this.generateComparisonFileContent(), comparisonFileName);
            String buildContrastScript = DESeq2.readFromJar("/DESeq2/buildContrast.R");
            description = this.stepId + "_" + this.experiment.getName() + "-buildcontrasts-" + StringUtils.toCompactTime((long)System.currentTimeMillis());
            this.executor.executeRScript(buildContrastScript, false, null, this.saveRScripts, description, workflowOutputDir, deseq2DesignFileName, this.model, comparisonFileName, this.experiment.getName() + CONTRAST_FILE_SUFFIX, this.stepId + "_");
        }
        if (this.normDiffana) {
            String normDiffanaScript = DESeq2.readFromJar("/DESeq2/normDiffana.R");
            description = this.stepId + "_" + this.experiment.getName() + "-normdiffana-" + StringUtils.toCompactTime((long)System.currentTimeMillis());
            this.executor.executeRScript(normDiffanaScript, false, null, this.saveRScripts, description, workflowOutputDir, this.createNormDiffanaCommandLine(deseq2DesignFileName, contrastFilename));
        }
        this.executor.removeInputFiles();
        this.executor.getOutputFiles();
        this.executor.closeConnection();
    }

    private static String readFromJar(String filePathInJar) throws IOException {
        InputStream is = DESeq2.class.getResourceAsStream(filePathInJar);
        StringBuilder sb = new StringBuilder();
        String line = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public DESeq2(RExecutor executor, String stepId, Design design, Experiment experiment, Map<String, File> sampleFiles, boolean normFig, boolean diffanaFig, boolean normDiffana, boolean diffana, SizeFactorsType sizeFactorsType, FitType fitType, StatisticTest statisticTest, boolean saveRScripts) {
        Objects.requireNonNull(stepId, "stepId argument cannot be null");
        Objects.requireNonNull(executor, "executor argument cannot be null");
        Objects.requireNonNull(design, "design argument cannot be null");
        Objects.requireNonNull(experiment, "experiment argument cannot be null");
        Objects.requireNonNull(sampleFiles, "sampleFiles argument cannot be null");
        Objects.requireNonNull(sizeFactorsType, "sizeFactorsType argument cannot be null");
        Objects.requireNonNull(fitType, "fitType argument cannot be null");
        Objects.requireNonNull(statisticTest, "statisticTest argument cannot be null");
        this.stepId = stepId;
        this.executor = executor;
        this.saveRScripts = saveRScripts;
        this.design = design;
        this.experiment = experiment;
        this.sampleFiles = sampleFiles;
        ExperimentMetadata expMD = experiment.getMetadata();
        this.model = expMD.containsModel() ? expMD.getModel() : "~Condition";
        this.contrast = expMD.containsContrast() ? expMD.isContrast() : expMD.containsContrastFile();
        if (expMD.containsContrastFile()) {
            this.contrastFile = new DataFile(expMD.getContrastFile());
            this.buildContrast = false;
        } else {
            this.contrastFile = null;
            this.buildContrast = expMD.containsBuildContrast() ? expMD.isBuildContrast() : false;
        }
        this.normFig = normFig;
        this.diffanaFig = diffanaFig;
        this.normDiffana = normDiffana;
        this.diffana = diffana;
        this.sizeFactorsType = sizeFactorsType;
        this.fitType = fitType;
        this.statisticTest = statisticTest;
    }

    public static enum StatisticTest {
        WALD("Wald"),
        LRT("LRT");

        private final String name;

        public String toDESeq2Value() {
            return this.name;
        }

        public static StatisticTest get(String name) throws EoulsanException {
            Objects.requireNonNull(name, "statisticTest cargument annot be null");
            String lowerName = name.trim().toLowerCase();
            for (StatisticTest dem : StatisticTest.values()) {
                if (!dem.toDESeq2Value().toLowerCase().equals(lowerName)) continue;
                return dem;
            }
            throw new EoulsanException("The value: " + name + " is not an acceptable value for the statisticTest option.");
        }

        private StatisticTest(String method) {
            this.name = method;
        }
    }

    public static enum FitType {
        PARAMETRIC,
        LOCAL,
        MEAN;


        public static FitType get(String name) throws EoulsanException {
            Objects.requireNonNull(name, "fitType argument cannot be null");
            String lowerName = name.trim().toLowerCase();
            for (FitType dem : FitType.values()) {
                if (!dem.name().toLowerCase().equals(lowerName)) continue;
                return dem;
            }
            throw new EoulsanException("The value: " + name + " is not an acceptable value for the fitType option.");
        }

        public String toDESeq2Value() {
            return this.name().toLowerCase();
        }
    }

    public static enum SizeFactorsType {
        RATIO,
        ITERATE;


        public static SizeFactorsType get(Parameter parameter) throws EoulsanException {
            Objects.requireNonNull(parameter, "parameter argument cannot be null");
            String lowerName = parameter.getLowerStringValue().trim();
            for (SizeFactorsType dem : SizeFactorsType.values()) {
                if (!dem.name().toLowerCase().equals(lowerName)) continue;
                return dem;
            }
            throw new EoulsanException("The value: " + parameter.getValue() + " is not an acceptable value for the " + parameter.getName() + " parameter.");
        }

        public String toDESeq2Value() {
            return this.name().toLowerCase();
        }
    }
}

