/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.diffana;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.checkers.DESeq2DesignChecker;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.DESeq2;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.RModuleCommonConfiguration;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVCountsReader;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@LocalOnly
public class DESeq2Module
extends AbstractModule {
    public static final String MODULE_NAME = "deseq2";
    static final String DESEQ2_DOCKER_IMAGE = "bioconductor/release_sequencing:3.1";
    private static final String NORMALIZATION_FIGURES = "norm.fig";
    private static final String DIFFANA_FIGURES = "diffana.fig";
    private static final String NORM_DIFFANA = "norm.diffana";
    private static final String DIFFANA = "diffana";
    private static final String SIZE_FACTORS_TYPE = "size.factors.type";
    private static final String FIT_TYPE = "fit.type";
    private static final String STATISTIC_TEST = "statistical.test";
    private boolean normFig = true;
    private boolean diffanaFig = true;
    private boolean normDiffana = true;
    private boolean diffana = true;
    private DESeq2.SizeFactorsType sizeFactorsType = DESeq2.SizeFactorsType.RATIO;
    private DESeq2.FitType fitType = DESeq2.FitType.PARAMETRIC;
    private DESeq2.StatisticTest statisticTest = DESeq2.StatisticTest.WALD;
    private final Set<Requirement> requirements = new HashSet<Requirement>();
    private RExecutor executor;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return new InputPortsBuilder().addPort("input", true, DataFormats.EXPRESSION_RESULTS_TSV).create();
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.unmodifiableSet(this.requirements);
    }

    @Override
    public Checker getChecker() {
        return new DESeq2DesignChecker();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        HashSet<Parameter> parameters = new HashSet<Parameter>(stepParameters);
        this.executor = RModuleCommonConfiguration.parseRExecutorParameter(context, parameters, this.requirements, DESEQ2_DOCKER_IMAGE);
        block18: for (Parameter p : parameters) {
            switch (p.getName()) {
                case "norm.fig": {
                    this.normFig = DESeq2Module.parseBoolean(p);
                    continue block18;
                }
                case "diffana.fig": {
                    this.diffanaFig = DESeq2Module.parseBoolean(p);
                    continue block18;
                }
                case "norm.diffana": {
                    this.normDiffana = DESeq2Module.parseBoolean(p);
                    continue block18;
                }
                case "diffana": {
                    this.diffana = DESeq2Module.parseBoolean(p);
                    continue block18;
                }
                case "size.factors.type": {
                    this.sizeFactorsType = DESeq2.SizeFactorsType.get(p);
                    continue block18;
                }
                case "fit.type": {
                    this.fitType = DESeq2.FitType.get(p.getStringValue());
                    continue block18;
                }
                case "statistical.test": {
                    this.statisticTest = DESeq2.StatisticTest.get(p.getStringValue());
                    continue block18;
                }
            }
            throw new EoulsanException("Unkown parameter for step " + this.getName() + " : " + p.getName());
        }
    }

    private static boolean parseBoolean(Parameter p) throws EoulsanException {
        if (p == null) {
            throw new NullPointerException("p parameter cannot be null");
        }
        String value = p.getLowerStringValue().trim();
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new EoulsanException("Invalid boolean value for parameter " + p.getName() + ": " + p.getValue());
        }
        return p.getBooleanValue();
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Design design = context.getWorkflow().getDesign();
        Data expressionData = context.getInputData(DataFormats.EXPRESSION_RESULTS_TSV);
        HashMap<String, File> sampleFiles = new HashMap<String, File>();
        for (Data data : expressionData.getListElements()) {
            sampleFiles.put(data.getName(), data.getDataFile().toFile());
        }
        String stepId = context.getCurrentStep().getId();
        try {
            DESeq2Module.checkIfAllCountAreNullInConditions(design, sampleFiles);
            for (Experiment e : design.getExperiments()) {
                if (DesignUtils.isSkipped(e)) continue;
                new DESeq2(this.executor, stepId, design, e, sampleFiles, this.normFig, this.diffanaFig, this.normDiffana, this.diffana, this.sizeFactorsType, this.fitType, this.statisticTest, context.getSettings().isSaveRscripts()).runDEseq2(context.getOutputDirectory());
            }
        }
        catch (EoulsanException | IOException exception) {
            return status.createTaskResult(exception, "Error while analysis data: " + exception.getMessage());
        }
        return status.createTaskResult();
    }

    private static boolean checkAllCountAreNullInExpressionFile(File file) throws FileNotFoundException, IOException {
        try (TSVCountsReader reader = new TSVCountsReader(file);){
            Map counts = reader.read();
            Iterator iterator = counts.values().iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                if (value <= 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private static void checkIfAllCountAreNullInConditions(Design design, Map<String, File> sampleFiles) throws FileNotFoundException, IOException, EoulsanException {
        String replicateId;
        String sampleId;
        HashMap<String, Boolean> emptyFiles = new HashMap<String, Boolean>();
        HashMap<String, String> technicalReplicates = new HashMap<String, String>();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Sample sample : design.getSamples()) {
            sampleId = sample.getId();
            if (sample.getMetadata().containsRepTechGroup()) {
                replicateId = sample.getMetadata().getRepTechGroup();
                technicalReplicates.put(sampleId, replicateId);
                continue;
            }
            technicalReplicates.put(sampleId, sampleId);
        }
        for (Map.Entry entry : sampleFiles.entrySet()) {
            emptyFiles.put((String)entry.getKey(), DESeq2Module.checkAllCountAreNullInExpressionFile((File)entry.getValue()));
        }
        for (Map.Entry entry : technicalReplicates.entrySet()) {
            sampleId = (String)entry.getKey();
            replicateId = (String)entry.getValue();
            if (!result.containsKey(replicateId)) {
                result.put(replicateId, true);
            }
            if (!((Boolean)result.get(replicateId)).booleanValue() || !emptyFiles.containsKey(sampleId) || ((Boolean)emptyFiles.get(sampleId)).booleanValue()) continue;
            result.put(replicateId, false);
        }
        for (Map.Entry entry : result.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            throw new EoulsanException("All the counts in the expression files are null for the the \"" + (String)entry.getKey() + "\" condition");
        }
    }
}

