/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.diffana;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.DiffAna;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import fr.ens.biologie.genomique.eoulsan.util.r.RSConnection;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Normalization {
    protected static final String TARGET_CREATION = "/DESeq1/targetCreation.Rnw";
    protected static final String NORMALIZATION_FUNCTIONS = "/DESeq1/normalization_anaDiff_RNAseq_Functions.R";
    private static final String NORMALISATION_PART1_WHITH_TECHREP = "/DESeq1/normalisationPart1WithTechRep.Rnw";
    private static final String NORMALIZATION_PART1_WHITHOUT_TECHREP = "/DESeq1/normalisationPart1WithoutTechRep.Rnw";
    private static final String CLUSTERING_PCA_RAW = "/DESeq1/clusteringAndPCARaw.Rnw";
    private static final String CLUSTERING_PCA_NORM = "/DESeq1/clusteringAndPCANorm.Rnw";
    private static final String NORMALIZATION_PART2 = "/DESeq1/normalizationPart2.Rnw";
    protected final Design design;
    protected final String expressionFilesPrefix;
    protected final String expressionFilesSuffix;
    protected RSConnection rConnection = null;
    protected final RExecutor executor;

    public void run(TaskContext context, Data data) throws EoulsanException {
        if (data.size() < 2) {
            throw new EoulsanException("Cannot run the analysis with less than 2 input files");
        }
        this.runRExecutor(context, data);
    }

    protected void runRExecutor(TaskContext context, Data data) throws EoulsanException {
        boolean saveRScript = context.getSettings().isSaveRscripts();
        DataFile workflowOutputDir = context.getOutputDirectory();
        try {
            for (Experiment experiment : this.design.getExperiments()) {
                if (DesignUtils.isSkipped(experiment)) continue;
                EoulsanLogger.getLogger().info("Experiment : " + experiment.getName());
                this.executor.openConnection();
                for (Data d : data.getListElements()) {
                    int sampleId = d.getMetadata().getSampleNumber();
                    if (sampleId == -1) {
                        throw new EoulsanException("No sample Id found for input file: " + d.getDataFile());
                    }
                    String linkFilename = this.expressionFilesPrefix + sampleId + this.expressionFilesSuffix;
                    this.executor.putInputFile(d.getDataFile(), linkFilename);
                }
                String rScript = this.generateScript(experiment, context);
                String description = context.getCurrentStep().getId() + "_" + experiment.getId() + "-" + StringUtils.toCompactTime((long)System.currentTimeMillis());
                String sweaveOutput = context.getCurrentStep().getId() + "_" + experiment.getId() + ".tex";
                this.executor.executeRScript(rScript, true, sweaveOutput, saveRScript, description, workflowOutputDir, new String[0]);
                this.executor.removeInputFiles();
                this.executor.getOutputFiles();
                this.executor.closeConnection();
            }
        }
        catch (IOException e) {
            throw new EoulsanException("Error while running differential analysis: " + e.getMessage(), e);
        }
    }

    protected boolean isTechnicalReplicates(List<String> rRepTechGroup) {
        HashMap<String, String> rtgMap = new HashMap<String, String>();
        for (String repTechGroup : rRepTechGroup) {
            if (rtgMap.containsKey(repTechGroup)) {
                return true;
            }
            rtgMap.put(repTechGroup, "");
        }
        return false;
    }

    protected String readStaticScript(String staticFile) throws EoulsanException {
        StringBuilder sb = new StringBuilder();
        InputStream is = DiffAna.class.getResourceAsStream(staticFile);
        try {
            String line;
            BufferedReader br = FileUtils.createBufferedReader((InputStream)is);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        catch (IOException e) {
            throw new EoulsanException("Error while reading a file" + e.getMessage());
        }
        return sb.toString();
    }

    protected String generateScript(Experiment experiment, TaskContext context) throws EoulsanException {
        HashMap conditionsMap = new HashMap();
        ArrayList<Integer> rSampleIds = new ArrayList<Integer>();
        ArrayList<String> rSampleNames = new ArrayList<String>();
        ArrayList<String> rCondNames = new ArrayList<String>();
        ArrayList<String> rRepTechGroup = new ArrayList<String>();
        int i = 0;
        for (Sample s : experiment.getSamples()) {
            List<Integer> index;
            String condition = DesignUtils.getCondition(experiment, s);
            if (condition == null) {
                throw new EoulsanException("No condition field found in design file.");
            }
            if ("".equals(condition)) {
                throw new EoulsanException("No value for condition in sample: " + s.getName() + " (" + s.getId() + ")");
            }
            String repTechGroup = DesignUtils.getRepTechGroup(experiment, s);
            if (repTechGroup != null && !"".equals(repTechGroup)) {
                rRepTechGroup.add(repTechGroup);
            }
            if (!conditionsMap.containsKey(condition)) {
                index = new ArrayList();
                conditionsMap.put(condition, index);
            } else {
                index = (List)conditionsMap.get(condition);
            }
            index.add(i);
            rSampleIds.add(s.getNumber());
            rSampleNames.add(s.getName());
            rCondNames.add(condition);
            ++i;
        }
        this.checkRepTechGroupCoherence(rRepTechGroup, rCondNames);
        String pdfTitle = this.escapeUnderScore(experiment.getName()) + " normalisation";
        String filePrefix = "normalization_" + this.escapeUnderScore(experiment.getName());
        StringBuilder sb = this.generateRnwpreamble(experiment.getSamples(), pdfTitle, filePrefix);
        this.replaceRtgNA(rRepTechGroup, rSampleNames);
        this.generateSampleNamePart(rSampleNames, sb);
        this.generateSampleIdsPart(rSampleIds, sb);
        this.generateExpressionFileNamesPart(sb);
        this.generateRepTechGroupPart(rRepTechGroup, sb);
        this.generateConditionPart(rCondNames, sb);
        sb.append("# projectPath : path of count files directory\n");
        sb.append("projectPath <- \"\"\n");
        sb.append("# outPath path of the outputs\n");
        sb.append("outPath <- \"./\"\n");
        sb.append("projectName <- \"");
        sb.append(experiment.getName());
        sb.append("\"\n@\n\n");
        sb.append(this.readStaticScript(TARGET_CREATION));
        sb.append("\\section{Analysis}\n\n");
        sb.append("\t\\subsection{Normalization}\n\n");
        sb.append("\\begin{itemize}\n\n");
        if (experiment.getSamples().size() > 2) {
            sb.append(this.readStaticScript(CLUSTERING_PCA_RAW));
        }
        if (this.isTechnicalReplicates(rRepTechGroup)) {
            sb.append(this.readStaticScript(NORMALISATION_PART1_WHITH_TECHREP));
        } else {
            sb.append(this.readStaticScript(NORMALIZATION_PART1_WHITHOUT_TECHREP));
        }
        if (this.isEnoughRepTechGroup(rRepTechGroup)) {
            sb.append(this.readStaticScript(CLUSTERING_PCA_NORM));
        }
        sb.append(this.readStaticScript(NORMALIZATION_PART2));
        sb.append("\\end{document}\n");
        return sb.toString();
    }

    protected StringBuilder generateRnwpreamble(List<Sample> experimentSamplesList, String title, String filePrefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\documentclass[a4paper,10pt]{article}\n");
        sb.append("\\usepackage[utf8]{inputenc}\n");
        sb.append("\\usepackage{lmodern}\n");
        sb.append("\\usepackage{a4wide}\n");
        sb.append("\\usepackage{marvosym}\n");
        sb.append("\\usepackage{graphicx}\n\n");
        sb.append("\\SweaveOpts{eps = FALSE, pdf = TRUE, prefix.string=");
        sb.append(filePrefix);
        sb.append("}\n\n");
        sb.append("\\setkeys{Gin}{width=0.95\textwidth}\n\n");
        sb.append("\\title{");
        sb.append(title);
        sb.append("}\n\n");
        sb.append("\\begin{document}\n");
        sb.append("\\maketitle\n\n");
        sb.append("<<functions, echo=FALSE>>=\n");
        sb.append("### Auto generated by ");
        sb.append("Eoulsan");
        sb.append(" ");
        sb.append(Globals.APP_VERSION_STRING);
        sb.append(" on ");
        sb.append(new Date(System.currentTimeMillis()));
        sb.append(" ###\n\n");
        try {
            sb.append(this.readStaticScript(NORMALIZATION_FUNCTIONS));
        }
        catch (EoulsanException e) {
            e.printStackTrace();
        }
        sb.append("@\n\n");
        sb.append("\\section{Initialization}\n");
        sb.append("<<>>=\n");
        return sb;
    }

    protected void generateSampleNamePart(List<String> rSampleNames, StringBuilder sb) {
        sb.append("# create sample names vector\n");
        sb.append("sampleNames <- c(");
        boolean first = true;
        for (String r : rSampleNames) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(r);
            sb.append('\"');
        }
        sb.append(")\n\n");
    }

    protected void generateSampleIdsPart(List<Integer> rSampleIds, StringBuilder sb) {
        sb.append("sampleIds <- c(");
        int i = 0;
        for (int id : rSampleIds) {
            sb.append(id);
            if (++i >= rSampleIds.size()) continue;
            sb.append(",");
        }
        sb.append(")\n\n");
    }

    protected void generateExpressionFileNamesPart(StringBuilder sb) {
        sb.append("#create file names vector\n");
        sb.append("fileNames <- paste(\"");
        sb.append(this.expressionFilesPrefix);
        sb.append("\",sampleIds,\"");
        sb.append(this.expressionFilesSuffix);
        sb.append("\",sep=\"\")\n\n");
    }

    protected void generateRepTechGroupPart(List<String> rRepTechGroup, StringBuilder sb) {
        if (this.isTechnicalReplicates(rRepTechGroup)) {
            sb.append("# create technical replicates groups vector\n");
            sb.append("repTechGroup <- c(");
            boolean first = true;
            for (String r : rRepTechGroup) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(r);
                sb.append('\"');
            }
            sb.append(")\n\n");
        } else {
            sb.append("# create technical replicates groups vector\n");
            sb.append("repTechGroup <- sampleNames\n\n");
        }
    }

    protected void generateConditionPart(List<String> rCondNames, StringBuilder sb) {
        sb.append("# create condition vector\n");
        sb.append("condition <- c(");
        boolean first = true;
        for (String r : rCondNames) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(r);
            sb.append('\"');
        }
        sb.append(")\n\n");
    }

    protected void checkRepTechGroupCoherence(List<String> rRepTechGroup, List<String> rCondNames) throws EoulsanException {
        HashMap<String, String> condRepTGMap = new HashMap<String, String>();
        for (int i = 0; i < rRepTechGroup.size(); ++i) {
            String repTechGroup = rRepTechGroup.get(i);
            String condition = rCondNames.get(i);
            if (repTechGroup.toLowerCase().equals("na")) continue;
            if (!condRepTGMap.containsKey(repTechGroup)) {
                condRepTGMap.put(repTechGroup, condition);
                continue;
            }
            if (((String)condRepTGMap.get(repTechGroup)).equals(condition)) continue;
            throw new EoulsanException("There is a mistake in RepTechGroup field of design file : two condition have the same repTechGroup value : " + repTechGroup);
        }
    }

    protected String escapeUnderScore(String s) {
        return s.replace("_", "\\_");
    }

    protected void replaceRtgNA(List<String> rRepTechGroup, List<String> rSampleNames) {
        for (int j = 0; j < rRepTechGroup.size(); ++j) {
            if (!rRepTechGroup.get(j).toLowerCase().equals("na")) continue;
            rRepTechGroup.set(j, rSampleNames.get(j));
        }
    }

    private boolean isEnoughRepTechGroup(List<String> rRepTechGroup) {
        ArrayList<String> repTechGroupMap = new ArrayList<String>();
        for (String r : rRepTechGroup) {
            if (!repTechGroupMap.contains(r)) {
                repTechGroupMap.add(r);
            }
            if (repTechGroupMap.size() <= 2) continue;
            return true;
        }
        return false;
    }

    public Normalization(RExecutor executor, Design design) throws EoulsanException {
        Objects.requireNonNull(design, "design is null.");
        this.design = design;
        DataFormat eDF = DataFormats.EXPRESSION_RESULTS_TSV;
        this.expressionFilesPrefix = eDF.getPrefix();
        this.expressionFilesSuffix = eDF.getDefaultExtension();
        this.executor = executor;
    }
}

