/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.diffana;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.Normalization;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.RModuleCommonConfiguration;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@LocalOnly
public class NormalizationModule
extends AbstractModule {
    private static final String MODULE_NAME = "normalization";
    static final String DESEQ1_DOCKER_IMAGE = "genomicpariscentre/deseq:1.8.3";
    private final Set<Requirement> requirements = new HashSet<Requirement>();
    private RExecutor executor;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public String getDescription() {
        return "This class compute normalisation of expression data for differential analysis.";
    }

    @Override
    public InputPorts getInputPorts() {
        return new InputPortsBuilder().addPort("input", true, DataFormats.EXPRESSION_RESULTS_TSV).create();
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.unmodifiableSet(this.requirements);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        HashSet<Parameter> parameters = new HashSet<Parameter>(stepParameters);
        this.executor = RModuleCommonConfiguration.parseRExecutorParameter(context, parameters, this.requirements, DESEQ1_DOCKER_IMAGE);
        if (!parameters.isEmpty()) {
            Modules.unknownParameter(context, (Parameter)parameters.iterator().next());
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            Design design = context.getWorkflow().getDesign();
            Normalization norm = new Normalization(this.executor, design);
            norm.run(context, context.getInputData(DataFormats.EXPRESSION_RESULTS_TSV));
            return status.createTaskResult();
        }
        catch (EoulsanException e) {
            return status.createTaskResult(e, "Error while normalizing expression data: " + e.getMessage());
        }
    }
}

