/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.diffana;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.requirements.DockerRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.PathRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.requirements.RserveRequirement;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutorFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class RModuleCommonConfiguration {
    public static final String EXECUTION_MODE_PARAMETER = "r.execution.mode";
    public static final String RSERVE_SERVER_PARAMETER = "rserve.servername";
    public static final String DOCKER_IMAGE_PARAMETER = "docker.image";

    public static RExecutor parseRExecutorParameter(StepConfigurationContext context, Set<Parameter> stepParameters, Set<Requirement> requirements, String defaultDockerImage) throws EoulsanException {
        RExecutor result;
        Objects.requireNonNull(context, "context argument cannot be null");
        Objects.requireNonNull(stepParameters, "stepParameters argument cannot be null");
        Objects.requireNonNull(requirements, "requirements argument cannot be null");
        Objects.requireNonNull(defaultDockerImage, "defaultDockerImage argument cannot be null");
        HashSet<Parameter> toRemove = new HashSet<Parameter>();
        Settings settings = context.getSettings();
        RExecutorFactory.Mode executionMode = null;
        String dockerImage = defaultDockerImage;
        String rserveServer = settings.isRServeServerEnabled() ? settings.getRServeServerName() : null;
        for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "r.execution.mode": {
                    executionMode = RExecutorFactory.Mode.parse(p.getStringValue());
                    if (executionMode == null) {
                        Modules.badParameterValue(context, p, "Unknown execution mode");
                    }
                    toRemove.add(p);
                    break;
                }
                case "rserve.servername": {
                    rserveServer = p.getStringValue();
                    toRemove.add(p);
                    break;
                }
                case "docker.image": {
                    dockerImage = p.getStringValue();
                    toRemove.add(p);
                    break;
                }
            }
        }
        stepParameters.removeAll(toRemove);
        try {
            result = RExecutorFactory.newRExecutor(executionMode, rserveServer, dockerImage, context.getStepOutputDirectory().toFile(), context.getLocalTempDirectory());
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
        switch (result.getName()) {
            case "process": {
                requirements.add(PathRequirement.newPathRequirement("Rscript"));
                break;
            }
            case "docker": {
                requirements.add(DockerRequirement.newDockerRequirement(dockerImage));
                break;
            }
            case "rserve": {
                requirements.add(RserveRequirement.newRserveRequirement(rserveServer));
                break;
            }
        }
        return result;
    }
}

