/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.expression.hadoop;

import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.modules.expression.ExpressionCounterCounter;
import fr.ens.biologie.genomique.eoulsan.modules.expression.hadoop.ExpressionMapper;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopReporterIncrementer;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.ExpressionCounter;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class ExpressionSAMOutputMapper
extends Mapper<Text, Text, Text, Text> {
    private ExpressionCounter counter;
    private String counterGroup;
    private final SAMLineParser parser = new SAMLineParser(new SAMFileHeader());
    private final Pattern recordSplitterPattern = Pattern.compile("\u00a3");
    private final List<SAMRecord> samRecords = new ArrayList<SAMRecord>();
    private ReporterIncrementer reporter;
    private final Text outKey = new Text("");
    private final Text outValue = new Text();

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        EoulsanLogger.initConsoleHandler();
        EoulsanLogger.getLogger().info("Start of setup()");
        Configuration conf = context.getConfiguration();
        this.counterGroup = conf.get(CommonHadoop.COUNTER_GROUP_KEY);
        if (this.counterGroup == null) {
            throw new IOException("No counter group defined");
        }
        this.reporter = new HadoopReporterIncrementer((TaskInputOutputContext)context);
        URI[] localCacheFiles = context.getCacheFiles();
        this.counter = ExpressionMapper.initCounterAndParser(conf, this.parser, localCacheFiles);
        EoulsanLogger.getLogger().info("End of setup()");
    }

    public void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String line = value.toString();
        if (!line.isEmpty() && line.charAt(0) == '@') {
            this.outKey.set("");
            this.outValue.set(line);
            context.write((Object)this.outKey, (Object)this.outValue);
            return;
        }
        this.samRecords.clear();
        try {
            for (String field : this.recordSplitterPattern.split(line)) {
                this.samRecords.add(this.parser.parseLine(field));
            }
            if (this.samRecords.isEmpty() || this.samRecords.size() > 2) {
                throw new EoulsanException("Invalid number of SAM record(s) found in the entry: " + this.samRecords.size());
            }
            this.counter.count(this.samRecords, this.reporter, this.counterGroup);
            for (SAMRecord samRecord : this.samRecords) {
                String samString = samRecord.getSAMString().replaceAll("\n", "");
                int tabPos = samString.indexOf(9);
                if (tabPos == -1) {
                    this.outKey.set("");
                } else {
                    this.outKey.set(samString.substring(0, tabPos));
                }
                this.outValue.set(samString);
                context.write((Object)this.outKey, (Object)this.outValue);
            }
        }
        catch (EoulsanException | KenetreException | SAMFormatException e) {
            context.getCounter(this.counterGroup, ExpressionCounterCounter.INVALID_SAM_ENTRIES_COUNTER.counterName()).increment(1L);
            EoulsanLogger.getLogger().info("Invalid SAM output entry: " + e.getMessage() + " line='" + line + "'");
        }
    }

    public void cleanup(Mapper.Context context) throws IOException {
    }
}

