/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.expression.hadoop;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.modules.expression.ExpressionCounterCounter;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.SAMHeaderHadoopUtils;
import fr.ens.biologie.genomique.kenetre.bio.SAMComparator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;

public class PreTreatmentExpressionReducer
extends Reducer<Text, Text, Text, Text> {
    private String counterGroup;
    private final Text outKey = new Text();
    private final Text outValue = new Text();
    private final SAMLineParser parser = new SAMLineParser(new SAMFileHeader());
    private final List<SAMRecord> records = new ArrayList<SAMRecord>();

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        EoulsanLogger.initConsoleHandler();
        EoulsanLogger.getLogger().info("Start of setup()");
        Configuration conf = context.getConfiguration();
        List<String> samHeader = SAMHeaderHadoopUtils.loadSAMHeaders((JobContext)context);
        this.parser.getFileHeader().setSequenceDictionary(SAMHeaderHadoopUtils.createSAMSequenceDictionaryFromSAMHeader(samHeader));
        this.counterGroup = conf.get(Globals.PARAMETER_PREFIX + ".counter.group");
        if (this.counterGroup == null) {
            throw new IOException("No counter group defined");
        }
        EoulsanLogger.getLogger().info("End of setup()");
    }

    protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        StringBuilder strOutValue = new StringBuilder();
        this.records.clear();
        for (Text val : values) {
            String stringVal = val.toString();
            String stringRecord = key.toString() + stringVal;
            try {
                SAMRecord samRecord = this.parser.parseLine(stringRecord);
                this.records.add(samRecord);
            }
            catch (SAMFormatException e) {
                context.getCounter(this.counterGroup, ExpressionCounterCounter.INVALID_SAM_ENTRIES_COUNTER.counterName()).increment(1L);
                EoulsanLogger.getLogger().info("Invalid SAM output entry: " + e.getMessage() + " line='" + stringRecord + "'");
                return;
            }
        }
        this.records.sort((Comparator<SAMRecord>)new SAMComparator());
        int indexOfFirstTab = this.records.get(0).getSAMString().indexOf("\t");
        String strOutKey = this.records.get(0).getSAMString().substring(0, indexOfFirstTab);
        strOutValue.append(this.records.get(0).getSAMString().substring(indexOfFirstTab + 1).replaceAll("\n", ""));
        this.records.remove(0);
        for (SAMRecord r : this.records) {
            if (r.getFirstOfPairFlag()) {
                strOutValue.append('\n');
            } else {
                strOutValue.append('\u00a3');
            }
            strOutValue.append(r.getSAMString().replaceAll("\n", ""));
        }
        this.outKey.set(strOutKey);
        this.outValue.set(strOutValue.toString());
        context.write((Object)this.outKey, (Object)this.outValue);
    }
}

