/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.fastqc;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.modules.fastqc.CounterSequenceFile;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;

public class SAMSequenceFile
implements CounterSequenceFile {
    private final DataFile file;
    private final SamReader reader;
    private final SAMRecordIterator iterator;
    private long count;

    public File getFile() {
        return new File(this.file.getName());
    }

    public int getPercentComplete() {
        return 0;
    }

    public boolean hasNext() {
        boolean result = this.iterator.hasNext();
        if (!result) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isColorspace() {
        return false;
    }

    public String name() {
        return this.file.getName();
    }

    public Sequence next() throws SequenceFormatException {
        SAMRecord record = (SAMRecord)this.iterator.next();
        ++this.count;
        return new Sequence((SequenceFile)this, record.getReadString(), record.getBaseQualityString(), record.getReadName());
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public SAMSequenceFile(DataFile inFile) throws IOException {
        Objects.requireNonNull(inFile, "file argument cannot be null");
        this.file = inFile;
        this.reader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)inFile.open()));
        this.iterator = this.reader.iterator();
    }
}

