/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.generators;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.bio.Sequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastaWriter;
import fr.ens.biologie.genomique.kenetre.bio.io.GFFFastaReader;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;

public class GFFFastaGeneratorModule
extends AbstractModule {
    public static final String MODULE_NAME = "gfffastagenerator";

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "Generate Genome Fasta file from a Fasta section of GFF file";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(DataFormats.ANNOTATION_GFF);
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.GENOME_FASTA);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            Data inData = context.getInputData(DataFormats.ANNOTATION_GFF);
            Data outData = context.getOutputData(DataFormats.GENOME_FASTA, inData);
            DataFile annotationDataFile = inData.getDataFile();
            DataFile genomeDataFile = outData.getDataFile();
            EoulsanLogger.getLogger().info("Input annotation file: " + annotationDataFile);
            EoulsanLogger.getLogger().info("Output genome file: " + genomeDataFile);
            GFFFastaReader reader = new GFFFastaReader(annotationDataFile.open());
            FastaWriter writer = new FastaWriter(genomeDataFile.create());
            for (Sequence sequence : reader) {
                writer.write(sequence);
            }
            reader.throwException();
            reader.close();
            writer.close();
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        status.setProgressMessage("Genome fasta creation");
        return status.createTaskResult();
    }
}

