/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.generators;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.InputPort;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.OutputPort;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ModuleRegistry;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@LocalOnly
public class GenericStorageGeneratorModule
extends AbstractModule {
    public static final String MODULE_NAME = "genericstoragegenerator";
    private Module module;
    private final List<Parameter> moduleParameter = new ArrayList<Parameter>();
    private boolean storeResult = true;
    private boolean useGenomeDescriptionForGenome;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        boolean genomeFound = false;
        boolean genomeDescFound = false;
        InputPortsBuilder builder = new InputPortsBuilder();
        for (InputPort p : this.module.getInputPorts()) {
            DataFormat format = p.getFormat();
            if (DataFormats.GENOME_FASTA.equals(format)) {
                genomeFound = true;
            }
            if (DataFormats.GENOME_DESC_TXT.equals(format)) {
                genomeDescFound = true;
            }
            builder.addPort(p.getName(), p.isList(), format, p.getCompressionsAccepted(), p.isRequiredInWorkingDirectory());
        }
        if (!genomeDescFound && genomeFound) {
            builder.addPort("genomedescription", DataFormats.GENOME_DESC_TXT);
            this.useGenomeDescriptionForGenome = true;
        }
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return this.module.getOutputPorts();
    }

    @Override
    public Set<Requirement> getRequirements() {
        return this.module.getRequirements();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block8: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "modulename": {
                    this.module = ModuleRegistry.getInstance().loadModule(p.getStringValue(), null);
                    if (this.module != null) continue block8;
                    throw new EoulsanException("The \"" + p.getStringValue() + "\" module cannot be loaded");
                }
                case "storeresult": {
                    this.storeResult = p.getBooleanValue();
                    continue block8;
                }
            }
            this.moduleParameter.add(p);
        }
        if (this.module == null) {
            throw new EoulsanException("The \"moduleName\" attribute is missing in the \"generator\" XML tag");
        }
        this.module.configure(context, stepParameters);
        if (this.getOutputPorts().size() != 1) {
            throw new EoulsanException("A generator can only have one output port. Found " + this.getOutputPorts().size() + " output ports");
        }
        if (((OutputPort)this.getOutputPorts().getFirstPort()).getFormat().getMaxFilesCount() > 1) {
            throw new EoulsanException("The generator output format cannot have multiple output files. Found " + ((OutputPort)this.getOutputPorts().getFirstPort()).getName() + " format");
        }
        this.moduleParameter.sort(Comparator.naturalOrder());
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        if (!this.storeResult) {
            return this.module.execute(context, status);
        }
        try {
            String storageName = ((OutputPort)this.getOutputPorts().getFirstPort()).getFormat().getPrefix();
            DataFile storageDirectory = GenericStorageGeneratorModule.getRepositoryDirectory(storageName, context);
            String md5 = this.computeMD5(context);
            context.getLogger().info("Computed MD5 sum is: " + md5);
            DataFile archiveFile = new DataFile(storageDirectory, md5 + ".zip");
            if (archiveFile.exists()) {
                context.getLogger().info("Use already computed data from archive: " + archiveFile);
                String unzippedFilename = GenericStorageGeneratorModule.firstZipEntryName(archiveFile);
                DataFile expectedOutputFile = context.getOutputData(((OutputPort)this.getOutputPorts().getFirstPort()).getName(), FileNaming.parse(unzippedFilename).getDataName()).getDataFile();
                DataFile unzippedDataFile = new DataFile(expectedOutputFile.getParent(), unzippedFilename);
                FileUtils.unzip((File)archiveFile.toFile(), (File)expectedOutputFile.getParent().toFile());
                if (!expectedOutputFile.equals(unzippedDataFile)) {
                    unzippedDataFile.renameTo(expectedOutputFile);
                }
                return status.createTaskResult();
            }
            context.getLogger().info("Data has not been already computed. Execute generator.");
            TaskResult result = this.module.execute(context, status);
            context.getLogger().info("Zip output of the generator in archive file: " + archiveFile);
            String outputFileprefix = FileNaming.filePrefix(context.getCurrentStep().getId(), ((OutputPort)this.getOutputPorts().getFirstPort()).getName(), ((OutputPort)this.getOutputPorts().getFirstPort()).getFormat());
            File[] filesToAdd = context.getStepOutputDirectory().toFile().listFiles(file -> file.getName().startsWith(outputFileprefix));
            FileUtils.createZip((File)context.getStepOutputDirectory().toFile(), Arrays.asList(filesToAdd), (File)archiveFile.toFile(), (boolean)false);
            return result;
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e);
        }
    }

    private static MessageDigest newMD5MessageDigest() throws EoulsanException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new EoulsanException("Unable to create MD5 message digest", e);
        }
    }

    private static List<String> computeAndSortInputFileMD5(Set<DataFile> inputFiles, TaskContext context) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (DataFile f : inputFiles) {
            String md5 = FileUtils.computeMD5Sum((InputStream)f.rawOpen());
            result.add(md5);
            context.getLogger().info("MD5 sum of " + f + " file: " + md5);
        }
        result.sort(Comparator.naturalOrder());
        return result;
    }

    private static DataFile getRepositoryDirectory(String storageName, TaskContext context) throws IOException {
        String storagePath = EoulsanRuntime.getSettings().getSetting("main." + storageName + ".data.storage.path");
        DataFile result = storagePath == null || storagePath.trim().isEmpty() ? new DataFile(((TaskContextImpl)context).getDataRepositoryDirectory(), storageName) : new DataFile(storagePath);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    private String computeMD5(TaskContext context) throws EoulsanException, IOException {
        HashSet<DataFile> inputFiles = new HashSet<DataFile>();
        for (Object port : this.module.getInputPorts()) {
            Data data = context.getInputData(port.getName());
            DataFormat format = data.getFormat();
            if (this.useGenomeDescriptionForGenome && (DataFormats.GENOME_FASTA.equals(format) || DataFormats.GENOME_DESC_TXT.equals(format))) continue;
            for (Data d : data.getListElements()) {
                if (format.getMaxFilesCount() > 1) {
                    for (int i = 0; i < d.getDataFileCount(); ++i) {
                        inputFiles.add(d.getDataFile(i));
                    }
                    continue;
                }
                inputFiles.add(d.getDataFile());
            }
        }
        MessageDigest md5Digest = GenericStorageGeneratorModule.newMD5MessageDigest();
        md5Digest.update(this.module.getName().getBytes(Globals.DEFAULT_CHARSET));
        md5Digest.update(this.module.getVersion().toString().getBytes(Globals.DEFAULT_CHARSET));
        for (Parameter p : this.moduleParameter) {
            md5Digest.update(p.getName().getBytes(Globals.DEFAULT_CHARSET));
            md5Digest.update(p.getStringValue().getBytes(Globals.DEFAULT_CHARSET));
        }
        if (this.useGenomeDescriptionForGenome) {
            context.getLogger().info("Load Genome description to get genome MD5 sum");
            GenomeDescription desc = GenomeDescription.load((InputStream)context.getInputData(DataFormats.GENOME_DESC_TXT).getDataFile().open());
            context.getLogger().info("Genome MD5 sum: " + desc.getMD5Sum());
            md5Digest.update(desc.getMD5Sum().getBytes(Globals.DEFAULT_CHARSET));
        }
        for (String md5Sum : GenericStorageGeneratorModule.computeAndSortInputFileMD5(inputFiles, context)) {
            md5Digest.update(md5Sum.getBytes(Globals.DEFAULT_CHARSET));
        }
        return StringUtils.md5DigestToString((MessageDigest)md5Digest);
    }

    private static List<String> listZipEntries(DataFile zipDataFile) throws ZipException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(zipDataFile.toFile());){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String fileName = zipEntries.nextElement().getName();
                result.add(fileName);
            }
        }
        return result;
    }

    private static String firstZipEntryName(DataFile zipDataFile) throws EoulsanException, ZipException, IOException {
        List<String> zipEntries = GenericStorageGeneratorModule.listZipEntries(zipDataFile);
        if (zipEntries.isEmpty()) {
            throw new EoulsanException("No data found in archive: " + zipDataFile);
        }
        String result = zipEntries.get(0);
        if (result.endsWith("/")) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }
}

