/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.generators;

import fr.ens.biologie.genomique.eoulsan.checkers.CheckStore;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.storages.DataFileGenomeDescStorage;
import fr.ens.biologie.genomique.eoulsan.modules.generators.GenomeDescriptionGeneratorModule;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import java.io.IOException;
import java.io.InputStream;

public class GenomeDescriptionCreator {
    private static final String CHECK_STORE_KEY = "genome_description";
    private final CheckStore checkStore;
    private final DataFileGenomeDescStorage storage = GenomeDescriptionGeneratorModule.checkForGenomeDescStore();

    public GenomeDescription createGenomeDescriptionFromAnnotation(DataFile annotationDataFile) throws BadBioEntryException, IOException {
        return this.createGenomeDescription(annotationDataFile, true);
    }

    public GenomeDescription createGenomeDescription(DataFile genomeDataFile) throws BadBioEntryException, IOException {
        return this.createGenomeDescription(genomeDataFile, false);
    }

    private GenomeDescription createGenomeDescription(DataFile genomeDataFile, boolean gffFormat) throws BadBioEntryException, IOException {
        GenomeDescription desc = (GenomeDescription)this.checkStore.get(CHECK_STORE_KEY);
        if (desc != null) {
            return desc;
        }
        if (this.storage != null) {
            desc = this.storage.get(genomeDataFile.getSource());
        }
        if (desc == null) {
            desc = GenomeDescription.createGenomeDescFromFasta((InputStream)genomeDataFile.open(), (String)genomeDataFile.getName());
            if (this.storage != null) {
                this.storage.put(genomeDataFile.getSource(), desc);
            }
        }
        this.checkStore.add(CHECK_STORE_KEY, desc);
        return desc;
    }

    public GenomeDescriptionCreator() {
        this.checkStore = CheckStore.getCheckStore();
    }
}

