/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.generators;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.data.storages.DataFileGenomeDescStorage;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.generators.GenomeDescriptionCreator;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;

public class GenomeDescriptionGeneratorModule
extends AbstractModule {
    public static final String MODULE_NAME = "genomedescgenerator";

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "Generate genome description";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(DataFormats.GENOME_FASTA);
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.GENOME_DESC_TXT);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data inData = context.getInputData(DataFormats.GENOME_FASTA);
        Data outData = context.getOutputData(DataFormats.GENOME_DESC_TXT, inData);
        try {
            DataFile genomeDataFile = inData.getDataFile();
            DataFile genomeDescriptionDataFile = outData.getDataFile();
            EoulsanLogger.getLogger().fine("Input genome file: " + genomeDataFile);
            EoulsanLogger.getLogger().fine("Output genome description file: " + genomeDescriptionDataFile);
            GenomeDescription desc = new GenomeDescriptionCreator().createGenomeDescription(genomeDataFile);
            desc.save(genomeDescriptionDataFile.create());
            EoulsanLogger.getLogger().fine("Genome description object: " + desc.toString());
        }
        catch (BadBioEntryException | IOException e) {
            return status.createTaskResult(e);
        }
        status.setProgressMessage("Genome description creation");
        return status.createTaskResult();
    }

    static DataFileGenomeDescStorage checkForGenomeDescStore() {
        String genomeDescStoragePath = EoulsanRuntime.getSettings().getGenomeDescStoragePath();
        if (genomeDescStoragePath == null) {
            return null;
        }
        return (DataFileGenomeDescStorage)DataFileGenomeDescStorage.getInstance(new DataFile(genomeDescStoragePath), EoulsanLogger.getGenericLogger());
    }
}

