/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.generators;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.Generator;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.data.MapperIndexDataFormat;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.generators.GenomeMapperIndexGeneratorModule;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperBuilder;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

@LocalOnly
@Generator
public class Minimap2IndexGeneratorModule
extends AbstractModule {
    public static final String MODULE_NAME = "minimap2indexgenerator";
    private final Mapper mapper = new MapperBuilder("minimap2").withLogger(EoulsanLogger.getGenericLogger()).build();
    private String indexerArguments = "";

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "Generate Mapper index";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return new InputPortsBuilder().addPort("genome", DataFormats.GENOME_FASTA).addPort("genomedescription", DataFormats.GENOME_DESC_TXT).create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(new MapperIndexDataFormat(this.mapper));
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        if (stepParameters == null) {
            throw new EoulsanException("No parameters set in " + this.getName() + " generator");
        }
        block6: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "indexer.arguments": {
                    this.indexerArguments = p.getStringValue();
                    continue block6;
                }
            }
            throw new EoulsanException("Unknown parameter for " + this.getName() + " step: " + p.getName());
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            status.setProgressMessage(this.mapper.getName() + " index creation");
            GenomeMapperIndexGeneratorModule.execute(this.mapper, context, this.indexerArguments, Collections.singletonMap("indexer.arguments", this.indexerArguments), context.getCurrentStep().getRequiredProcessors());
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }
}

