/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.data.MapperIndexDataFormat;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractReadsFilterModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractReadsMapperModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractSAMFilterModule;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.MultiReadAlignmentFilterBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.MultiReadFilterBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstanceBuilder;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFilterAndMapReadsModule
extends AbstractModule {
    public static final String MODULE_NAME = "filterandmap";
    private static final String COUNTER_GROUP = "filter_map_reads";
    protected static final String READS_PORT_NAME = "reads";
    protected static final String MAPPER_INDEX_PORT_NAME = "mapperindex";
    protected static final String GENOME_DESCRIPTION_PORT_NAME = "genomedescription";
    protected static final int HADOOP_TIMEOUT = 3600000;
    private boolean pairedEnd;
    private Map<String, String> readsFiltersParameters;
    private Map<String, String> alignmentsFiltersParameters;
    private Mapper mapper;
    private String mapperVersion = "";
    private String mapperFlavor = "";
    private String mapperArguments;
    private int reducerTaskCount = -1;
    private int hadoopThreads = -1;
    private int hadoopMapperRequiredMemory = 8192;

    protected String getCounterGroup() {
        return COUNTER_GROUP;
    }

    protected boolean isPairedEnd() {
        return this.pairedEnd;
    }

    protected String getMapperName() {
        return this.mapper.getName();
    }

    protected String getMapperVersion() {
        return this.mapperVersion;
    }

    protected String getMapperFlavor() {
        return this.mapperVersion;
    }

    protected String getMapperArguments() {
        return this.mapperArguments;
    }

    protected int getMapperHadoopThreads() {
        return this.hadoopThreads;
    }

    protected int getMapperHadoopMemoryRequired() {
        return this.hadoopMapperRequiredMemory;
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    protected int getReducerTaskCount() {
        return this.reducerTaskCount;
    }

    protected Map<String, String> getReadFilterParameters() {
        return this.readsFiltersParameters;
    }

    protected Map<String, String> getAlignmentsFilterParameters() {
        return this.alignmentsFiltersParameters;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort(READS_PORT_NAME, DataFormats.READS_FASTQ);
        builder.addPort(MAPPER_INDEX_PORT_NAME, new MapperIndexDataFormat(this.mapper));
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public String getDescription() {
        return "This step filters, map reads and filter alignment results.";
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        String mapperName = null;
        MultiReadFilterBuilder readFilterBuilder = new MultiReadFilterBuilder(EoulsanLogger.getGenericLogger());
        MultiReadAlignmentFilterBuilder alignmentsFilterBuilder = new MultiReadAlignmentFilterBuilder(EoulsanLogger.getGenericLogger());
        try {
            block20: for (Parameter p : stepParameters) {
                AbstractReadsFilterModule.checkDeprecatedParameter(context, p);
                AbstractReadsMapperModule.checkDeprecatedParameter(context, p);
                AbstractSAMFilterModule.checkDeprecatedParameter(context, p);
                switch (p.getName()) {
                    case "mapper": {
                        mapperName = p.getStringValue();
                        continue block20;
                    }
                    case "mapper.version": {
                        this.mapperVersion = p.getStringValue();
                        continue block20;
                    }
                    case "mapper.flavor": {
                        this.mapperFlavor = p.getStringValue();
                        continue block20;
                    }
                    case "mapper.arguments": {
                        this.mapperArguments = p.getStringValue();
                        continue block20;
                    }
                    case "hadoop.threads": {
                        this.hadoopThreads = p.getIntValueGreaterOrEqualsTo(1);
                        continue block20;
                    }
                    case "hadoop.reducer.task.count": {
                        this.reducerTaskCount = p.getIntValueGreaterOrEqualsTo(1);
                        continue block20;
                    }
                }
                if (readFilterBuilder.addParameter(p.getName(), p.getStringValue(), true) || alignmentsFilterBuilder.addParameter(p.getName(), p.getStringValue(), true)) continue;
                Modules.unknownParameter(context, p);
            }
            readFilterBuilder.getReadFilter();
            alignmentsFilterBuilder.getAlignmentFilter();
        }
        catch (KenetreException e) {
            throw new EoulsanException(e);
        }
        this.readsFiltersParameters = readFilterBuilder.getParameters();
        this.alignmentsFiltersParameters = alignmentsFilterBuilder.getParameters();
        if (mapperName == null) {
            Modules.invalidConfiguration(context, "No mapper set");
        }
        try {
            this.mapper = new MapperBuilder(mapperName).withLogger(EoulsanLogger.getGenericLogger()).withApplicationName("Eoulsan").withApplicationVersion(Globals.APP_VERSION_STRING).withTempDirectory(EoulsanRuntime.getSettings().getTempDirectoryFile()).withExecutablesTempDirectory(EoulsanRuntime.getSettings().getExecutablesTempDirectoryFile()).build();
            if (this.mapper == null) {
                Modules.invalidConfiguration(context, "Unknown mapper: " + mapperName);
            }
            if (this.mapper.isIndexGeneratorOnly()) {
                Modules.invalidConfiguration(context, "The selected mapper can only be used for index generation: " + mapperName);
            }
            new MapperInstanceBuilder(this.mapper).withMapperVersion(this.mapperVersion).withMapperFlavor(this.mapperFlavor).withUseBundledBinaries(true).build();
            if (this.mapper.isIndexGeneratorOnly()) {
                Modules.invalidConfiguration(context, "The selected mapper can only be used for index generation: " + mapperName);
            }
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
        int requiredMemory = context.getCurrentStep().getRequiredMemory();
        if (requiredMemory > 0) {
            this.hadoopMapperRequiredMemory = requiredMemory;
        }
        EoulsanLogger.getLogger().info("In " + this.getName() + ", mapper=" + this.mapper.getName() + " (version: " + this.mapperVersion + ")");
        EoulsanLogger.getLogger().info("In " + this.getName() + ", mapperarguments=" + this.mapperArguments);
    }
}

