/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Set;

public abstract class AbstractSAM2BAMModule
extends AbstractModule {
    private static final String MODULE_NAME = "sam2bam";
    private static final int DEFAULT_COMPRESSION_LEVEL = 5;
    private static final int DEFAULT_MAX_RECORDS_IN_RAM = 500000;
    protected static final String COUNTER_GROUP = "sam2bam";
    private int compressionLevel = 5;
    private int reducerTaskCount = -1;
    private int maxRecordsInRam = 500000;

    protected int getCompressionLevel() {
        return this.compressionLevel;
    }

    protected int getReducerTaskCount() {
        return this.reducerTaskCount;
    }

    protected int getMaxRecordsInRam() {
        return this.maxRecordsInRam;
    }

    @Override
    public String getName() {
        return "sam2bam";
    }

    @Override
    public String getDescription() {
        return "This module sam convert SAM files to BAM files.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public OutputPorts getOutputPorts() {
        return new OutputPortsBuilder().addPort("bam", DataFormats.MAPPER_RESULTS_BAM).addPort("bai", DataFormats.MAPPER_RESULTS_INDEX_BAI).create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block12: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "compression.level": {
                    this.compressionLevel = p.getIntValueInRange(0, 9);
                    continue block12;
                }
                case "input.format": {
                    Modules.deprecatedParameter(context, p, true);
                    continue block12;
                }
                case "max.entries.in.ram": {
                    this.maxRecordsInRam = p.getIntValueGreaterOrEqualsTo(1);
                    continue block12;
                }
                case "hadoop.reducer.task.count": {
                    this.reducerTaskCount = p.getIntValueGreaterOrEqualsTo(1);
                    continue block12;
                }
            }
            Modules.unknownParameter(context, p);
        }
    }
}

