/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Set;

public abstract class AbstractSAM2FASTQModule
extends AbstractModule {
    private static final String MODULE_NAME = "sam2fastq";
    protected static final String COUNTER_GROUP = "sam2fastq";
    private int reducerTaskCount = -1;

    protected int getReducerTaskCount() {
        return this.reducerTaskCount;
    }

    @Override
    public String getName() {
        return "sam2fastq";
    }

    @Override
    public String getDescription() {
        return "This module sam convert SAM files to FASTQ files.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public OutputPorts getOutputPorts() {
        return new OutputPortsBuilder().addPort("fastq", DataFormats.READS_FASTQ).create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block8: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "input.format": {
                    EoulsanLogger.getLogger().warning("Deprecated parameter \"" + p.getName() + "\" for step " + this.getName());
                    continue block8;
                }
                case "hadoop.reducer.task.count": {
                    this.reducerTaskCount = p.getIntValueGreaterOrEqualsTo(1);
                    continue block8;
                }
            }
            throw new EoulsanException("Unknown parameter for " + this.getName() + " step: " + p.getName());
        }
    }
}

