/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.MultiReadAlignmentFilter;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.MultiReadAlignmentFilterBuilder;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSAMFilterModule
extends AbstractModule {
    private static final String MODULE_NAME = "filtersam";
    protected static final String COUNTER_GROUP = "sam_filtering";
    private Map<String, String> alignmentsFiltersParameters;
    private int reducerTaskCount = -1;

    protected Map<String, String> getAlignmentsFilterParameters() {
        return this.alignmentsFiltersParameters;
    }

    protected int getReducerTaskCount() {
        return this.reducerTaskCount;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "This module filters sam files.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        try {
            MultiReadAlignmentFilterBuilder filterBuilder = new MultiReadAlignmentFilterBuilder(context.getGenericLogger());
            block8: for (Parameter p : stepParameters) {
                AbstractSAMFilterModule.checkDeprecatedParameter(context, p);
                switch (p.getName()) {
                    case "hadoop.reducer.task.count": {
                        this.reducerTaskCount = p.getIntValueGreaterOrEqualsTo(1);
                        continue block8;
                    }
                }
                filterBuilder.addParameter(p.getName(), p.getStringValue());
            }
            filterBuilder.getAlignmentFilter();
            this.alignmentsFiltersParameters = filterBuilder.getParameters();
        }
        catch (KenetreException e) {
            throw new EoulsanException(e);
        }
    }

    static void checkDeprecatedParameter(StepConfigurationContext context, Parameter parameter) throws EoulsanException {
        if (parameter == null) {
            return;
        }
        switch (parameter.getName()) {
            case "mappingqualitythreshold": 
            case "mappingquality": 
            case "mappingquality.threshold": {
                Modules.renamedParameter(context, parameter, "quality.threshold", true);
            }
        }
    }

    protected MultiReadAlignmentFilter getAlignmentFilter(GenericLogger logger, ReporterIncrementer incrementer, String counterGroup) throws EoulsanException {
        try {
            return new MultiReadAlignmentFilterBuilder(logger, this.alignmentsFiltersParameters).getAlignmentFilter(incrementer, counterGroup);
        }
        catch (KenetreException e) {
            throw new EoulsanException(e);
        }
    }
}

