/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.util.SAMOutputPreparer;

public class HadoopBamUtils {
    private static final String HEADERMERGER_SORTORDER_PROP = "hadoopbam.headermerger.sortorder";

    public static SamFileHeaderMerger getSAMHeaderMerger(Configuration conf) throws IOException {
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
        for (String in : conf.getStrings("hadoopbam.headermerger.inputs")) {
            Path p = new Path(in);
            SamReader r = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)p.getFileSystem(conf).open(p)));
            headers.add(r.getFileHeader());
            r.close();
        }
        String orderStr = conf.get(HEADERMERGER_SORTORDER_PROP);
        SAMFileHeader.SortOrder order = orderStr == null ? SAMFileHeader.SortOrder.unsorted : SAMFileHeader.SortOrder.valueOf((String)orderStr);
        return new SamFileHeaderMerger(order, headers, true);
    }

    public static void mergeSAMInto(Path out, Path directory, String basePrefix, String basePostfix, SAMFormat format, Configuration conf, String commandName) throws IOException {
        FSDataOutputStream outs = out.getFileSystem(conf).create(out);
        new SAMOutputPreparer().prepareForRecords((OutputStream)outs, format, HadoopBamUtils.getSAMHeaderMerger(conf).getMergedHeader());
        HadoopBamUtils.mergeInto((OutputStream)outs, directory, basePrefix, basePostfix, conf, commandName);
        if (format == SAMFormat.BAM) {
            outs.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        }
        outs.close();
    }

    public static void mergeInto(OutputStream out, Path directory, String basePrefix, String basePostfix, Configuration conf, String commandName) throws IOException {
        FileStatus[] parts;
        FileSystem fs = directory.getFileSystem(conf);
        for (FileStatus part : parts = fs.globStatus(new Path(directory, basePrefix + conf.get("hadoopbam.work.filename") + basePostfix + "-[0-9][0-9][0-9][0-9][0-9][0-9]*"))) {
            FSDataInputStream in = fs.open(part.getPath());
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
            in.close();
        }
        for (FileStatus part : parts) {
            fs.delete(part.getPath(), false);
        }
    }
}

