/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class HadoopMappingUtils {
    private static final String PARAM_KEYS_LIST_SUFFIX = "*.list";

    static void addParametersToJobConf(Map<String, String> parameters, String prefix, Configuration jobConf) {
        if (parameters == null || jobConf == null || prefix == null) {
            return;
        }
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            String key = prefix + e.getKey();
            String value = e.getValue();
            jobConf.set(key, value);
        }
        jobConf.set(prefix + PARAM_KEYS_LIST_SUFFIX, Joiner.on((char)',').join(parameters.keySet()));
    }

    static Map<String, String> jobConfToParameters(Configuration jobConf, String prefix) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (jobConf == null || prefix == null) {
            return result;
        }
        String keys = jobConf.get(prefix + PARAM_KEYS_LIST_SUFFIX);
        if (keys == null) {
            return result;
        }
        Iterator iterator = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)keys).iterator();
        while (iterator.hasNext()) {
            String key;
            String value = jobConf.get(prefix + (key = (String)iterator.next()));
            result.put(key, value == null ? "" : value);
        }
        return result;
    }

    private HadoopMappingUtils() {
        throw new IllegalStateException();
    }
}

