/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.bio.io.hadoop.FastqInputFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class PairedEndFastqToTfq {
    public static Job convert(Configuration parentConf, DataFile fastqFile1, DataFile fastqFile2, DataFile outputFile, int reducerTaskCount) throws IOException {
        Objects.requireNonNull(parentConf, "parentConf argument cannot be null");
        Objects.requireNonNull(fastqFile1, "fastqFile1 argument cannot be null");
        Objects.requireNonNull(fastqFile2, "fastqFile2 argument cannot be null");
        Objects.requireNonNull(outputFile, "outputFile argument cannot be null");
        return PairedEndFastqToTfq.convert(parentConf, new Path(fastqFile1.getSource()), new Path(fastqFile2.getSource()), new Path(outputFile.getSource()), reducerTaskCount);
    }

    public static Job convert(Configuration parentConf, Path fastqFile1, Path fastqFile2, Path outputFile, int reducerTaskCount) throws IOException {
        Objects.requireNonNull(parentConf, "parentConf argument cannot be null");
        Objects.requireNonNull(fastqFile1, "fastqFile1 argument cannot be null");
        Objects.requireNonNull(fastqFile2, "fastqFile2 argument cannot be null");
        Objects.requireNonNull(outputFile, "outputFile argument cannot be null");
        Configuration jobConf = new Configuration(parentConf);
        Job job = Job.getInstance((Configuration)jobConf, (String)("Convert FASTQ paired files in TFQ (" + fastqFile1.getName() + ", " + fastqFile2.getName() + ", " + outputFile.getName() + ")"));
        job.setJarByClass(PairedEndFastqToTfq.class);
        FileInputFormat.addInputPath((Job)job, (Path)fastqFile1);
        FileInputFormat.addInputPath((Job)job, (Path)fastqFile2);
        job.setInputFormatClass(FastqInputFormat.class);
        job.setReducerClass(FastqPairedEndReducer.class);
        job.setCombinerClass(FastqPairedEndReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        if (reducerTaskCount > 0) {
            job.setNumReduceTasks(reducerTaskCount);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outputFile);
        return job;
    }

    public static final class FastqPairedEndReducer
    extends Reducer<Text, Text, Text, Text> {
        private static final Joiner JOINER = Joiner.on((char)'\t');

        protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            ArrayList<String> list = new ArrayList<String>();
            for (Text t : values) {
                list.add(t.toString());
            }
            Collections.sort(list);
            context.write((Object)key, (Object)new Text(JOINER.join(list)));
        }
    }
}

