/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopReporter;
import fr.ens.biologie.genomique.eoulsan.util.locker.DistributedLocker;
import fr.ens.biologie.genomique.eoulsan.util.locker.Locker;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperIndex;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstanceBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class ReadsMapperMapper
extends Mapper<Text, Text, Text, Text> {
    static final String MAPPER_NAME_KEY = Globals.PARAMETER_PREFIX + ".mapper.name";
    static final String MAPPER_VERSION_KEY = Globals.PARAMETER_PREFIX + ".mapper.version";
    static final String MAPPER_FLAVOR_KEY = Globals.PARAMETER_PREFIX + ".mapper.flavor";
    static final String PAIR_END_KEY = Globals.PARAMETER_PREFIX + ".mapper.pairend";
    static final String MAPPER_ARGS_KEY = Globals.PARAMETER_PREFIX + ".mapper.args";
    static final String MAPPER_THREADS_KEY = Globals.PARAMETER_PREFIX + ".mapper.nb.threads";
    static final String FASTQ_FORMAT_KEY = Globals.PARAMETER_PREFIX + ".mapper.fastq.format";
    static final String INDEX_CHECKSUM_KEY = Globals.PARAMETER_PREFIX + ".mapper.index.checksum";
    static final String ZOOKEEPER_CONNECT_STRING_KEY = Globals.PARAMETER_PREFIX + ".mapper.zookeeper.connect.string";
    static final String ZOOKEEPER_SESSION_TIMEOUT_KEY = Globals.PARAMETER_PREFIX + ".mapper.zookeeper.session.timeout";
    private static final Splitter TAB_SPLITTER = Splitter.on((char)'\t').trimResults();
    private static final String MAPPER_INDEX_DIR_PREFIX = "Eoulsan-mapper-index-";
    private static final String MAPPER_LAST_USED_FILENAME = "Eoulsan".toUpperCase() + "_LAST_USED";
    private static final long DEFAULT_AGE_OF_UNUSED_MAPPER_INDEXES = 7L;
    private static final String LOCK_SUFFIX = ".lock";
    private String counterGroup = ((Object)((Object)this)).getClass().getName();
    private File mapperIndexDir;
    private Locker lock;
    private EntryMapping mapping;
    private MapperProcess process;
    private Thread samResultsParserThread;
    private final BlockingDeque<String> queue = new LinkedBlockingDeque<String>();
    private final ExceptionWrapper exception = new ExceptionWrapper();
    private int entriesParsed;
    private boolean writeHeaders;
    private final List<String> fields = new ArrayList<String>();
    private final Text outKey = new Text();
    private final Text outValue = new Text();

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        this.fields.clear();
        for (String e : TAB_SPLITTER.split((CharSequence)value.toString())) {
            this.fields.add(e);
        }
        int fieldsSize = this.fields.size();
        if (fieldsSize == 3) {
            this.process.writeEntry(this.fields.get(0), this.fields.get(1), this.fields.get(2));
        } else if (fieldsSize == 6) {
            this.process.writeEntry(this.fields.get(0), this.fields.get(1), this.fields.get(2), this.fields.get(3), this.fields.get(4), this.fields.get(5));
        }
        this.writeResults(context, this.writeHeaders);
    }

    protected void setup(Mapper.Context context) throws IOException {
        String mapperName;
        EoulsanLogger.initConsoleHandler();
        EoulsanLogger.getLogger().info("Start of setup()");
        Configuration conf = context.getConfiguration();
        if (!EoulsanRuntime.isRuntime()) {
            HadoopEoulsanRuntime.newEoulsanRuntime(conf);
        }
        if ((mapperName = conf.get(MAPPER_NAME_KEY)) == null) {
            throw new IOException("No mapper set");
        }
        File tempDir = EoulsanRuntime.getRuntime().getTempDirectory();
        if (!tempDir.exists()) {
            EoulsanLogger.getLogger().fine("Create temporary directory: " + tempDir.getAbsolutePath());
            if (!tempDir.mkdirs()) {
                throw new IOException("Unable to create local Hadoop temporary directory: " + tempDir);
            }
        }
        fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper mapper = new MapperBuilder(mapperName).withLogger(EoulsanLogger.getGenericLogger()).withApplicationName("Eoulsan").withApplicationVersion(Globals.APP_VERSION_STRING).withTempDirectory(tempDir).withExecutablesTempDirectory(tempDir).build();
        MapperInstance mapperInstance = new MapperInstanceBuilder(mapper).withMapperVersion(conf.get(MAPPER_VERSION_KEY)).withMapperFlavor(conf.get(MAPPER_FLAVOR_KEY)).withUseBundledBinaries(true).build();
        String counterGroup = conf.get(CommonHadoop.COUNTER_GROUP_KEY);
        if (counterGroup != null) {
            this.counterGroup = counterGroup;
        }
        boolean pairedEnd = Boolean.parseBoolean(conf.get(PAIR_END_KEY));
        FastqFormat fastqFormat = FastqFormat.getFormatFromName((String)conf.get(FASTQ_FORMAT_KEY, "" + EoulsanRuntime.getSettings().getDefaultFastqFormat()));
        URI[] localCacheFiles = context.getCacheFiles();
        if (localCacheFiles == null || localCacheFiles.length == 0) {
            throw new IOException("Unable to retrieve genome index");
        }
        if (localCacheFiles.length > 1) {
            throw new IOException("Retrieve more than one file in distributed cache");
        }
        EoulsanLogger.getLogger().info("localCacheFiles[0]: " + localCacheFiles[0]);
        DataFile archiveIndexFile = new DataFile(localCacheFiles[0].toString());
        EoulsanLogger.getLogger().info("Genome index compressed file (from distributed cache): " + archiveIndexFile);
        this.mapperIndexDir = new File(EoulsanRuntime.getRuntime().getTempDirectory(), MAPPER_INDEX_DIR_PREFIX + mapper.getName() + "-index-" + conf.get(INDEX_CHECKSUM_KEY));
        EoulsanLogger.getLogger().info("Genome index directory where decompressed: " + this.mapperIndexDir);
        MapperIndex mapperIndex = mapperInstance.newMapperIndex(archiveIndexFile.open(), this.mapperIndexDir);
        EoulsanLogger.getLogger().info("Fastq format: " + fastqFormat);
        this.lock = new DistributedLocker(conf.get(ZOOKEEPER_CONNECT_STRING_KEY), Integer.parseInt(conf.get(ZOOKEEPER_SESSION_TIMEOUT_KEY)), "/eoulsan-locks-" + InetAddress.getLocalHost().getHostName(), "eoulsan-mapper-lock");
        String mapperArguments = StringUtils.unDoubleQuotes((String)conf.get(MAPPER_ARGS_KEY));
        int mapperThreads = Integer.parseInt(conf.get(MAPPER_THREADS_KEY, "" + Runtime.getRuntime().availableProcessors()));
        if (mapperThreads > Runtime.getRuntime().availableProcessors() || mapperThreads < 1) {
            mapperThreads = Runtime.getRuntime().availableProcessors();
        }
        EoulsanLogger.getLogger().info("Use " + mapper.getName() + " with " + mapperThreads + " threads option");
        this.updateLastUsedMapperIndex(this.mapperIndexDir);
        context.setStatus("Wait lock");
        ProcessUtils.waitRandom(5000);
        this.lock.lock();
        this.mapping = mapperIndex.newEntryMapping(fastqFormat, mapperArguments, mapperThreads, true, (ReporterIncrementer)new HadoopReporter((TaskInputOutputContext)context), this.counterGroup);
        if (this.mapping.isMultipleInstancesEnabled()) {
            this.lock.unlock();
        } else {
            context.setStatus("Wait free JVM for running " + this.mapping.getName());
            this.waitFreeJVM(context);
        }
        this.process = pairedEnd ? this.mapping.mapPE() : this.mapping.mapSE();
        this.writeHeaders = context.getTaskAttemptID().getTaskID().getId() == 0;
        this.samResultsParserThread = this.startParseSAMResultsThread(this.process);
        context.setStatus("Run " + this.mapping.getName());
        EoulsanLogger.getLogger().info("End of setup()");
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        EoulsanLogger.getLogger().info("Start of cleanup() of the mapper.");
        this.process.closeEntriesWriter();
        this.samResultsParserThread.join();
        this.process.waitFor();
        if (!this.mapping.isMultipleInstancesEnabled()) {
            this.lock.unlock();
        }
        this.writeResults(context, this.writeHeaders);
        EoulsanLogger.getLogger().info(this.entriesParsed + " entries parsed in " + this.mapping.getName() + " output file");
        this.removeUnusedMapperIndexes(context.getConfiguration());
        EoulsanLogger.getLogger().info("End of close() of the mapper.");
    }

    private void waitFreeJVM(Mapper.Context context) {
        long waitStartTime = System.currentTimeMillis();
        ProcessUtils.waitUntilExecutableRunning(this.mapping.getMapperInstance().getMapper().getProvider().getMapperExecutableName(this.mapping.getMapperInstance()));
        EoulsanLogger.getLogger().info("Wait " + StringUtils.toTimeHumanReadable((long)(System.currentTimeMillis() - waitStartTime)) + " before running " + this.mapping.getName());
        context.setStatus("Run " + this.mapping.getName());
    }

    private Thread startParseSAMResultsThread(MapperProcess mp) {
        Thread t = new Thread(() -> {
            try (BufferedReader readerResults = new BufferedReader(new InputStreamReader(mp.getStout()));){
                String line;
                while ((line = readerResults.readLine()) != null) {
                    this.queue.add(line);
                }
            }
            catch (IOException e) {
                this.exception.exception = e;
            }
        });
        t.start();
        return t;
    }

    private void writeResults(Mapper.Context context, boolean writeHeader) throws InterruptedException, IOException {
        while (!this.queue.isEmpty()) {
            boolean headerLine;
            String line = this.queue.take().trim();
            if (line.length() == 0) continue;
            boolean bl = headerLine = line.charAt(0) == '@';
            if (headerLine && !writeHeader) continue;
            if (!headerLine) {
                int tabPos = line.indexOf(9);
                if (tabPos == -1) {
                    this.outKey.set("");
                } else {
                    this.outKey.set(line.substring(0, tabPos));
                }
                ++this.entriesParsed;
                context.getCounter(this.counterGroup, MappingCounters.OUTPUT_MAPPING_ALIGNMENTS_COUNTER.counterName()).increment(1L);
            } else {
                this.outKey.set("");
            }
            this.outValue.set(line);
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        if (this.exception.exception != null) {
            throw this.exception.exception;
        }
    }

    private void updateLastUsedMapperIndex(File mapperIndexDir) {
        File lockFile = new File(mapperIndexDir.getParentFile(), mapperIndexDir.getName() + LOCK_SUFFIX);
        try (FileOutputStream out = new FileOutputStream(lockFile);){
            FileLock lock = out.getChannel().lock();
            File lastMapperUsedFile = new File(mapperIndexDir, MAPPER_LAST_USED_FILENAME);
            if (lastMapperUsedFile.exists() && !lastMapperUsedFile.setLastModified(System.currentTimeMillis())) {
                EoulsanLogger.getLogger().warning("Unable to set the modification time of the file: " + lastMapperUsedFile);
            }
            lock.release();
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().warning("Cannot update the timestamp of the last usage of the current mapper index: " + e.getMessage());
        }
    }

    private void removeUnusedMapperIndexes(Configuration conf) {
        File mapperIndexesDir = this.mapperIndexDir.getParentFile();
        for (File dir2 : mapperIndexesDir.listFiles((dir, name) -> {
            File f = new File(dir, name);
            return f.isDirectory() && name.startsWith(MAPPER_INDEX_DIR_PREFIX);
        })) {
            if (!this.isMapperIndexMustBeRemoved(mapperIndexesDir)) continue;
            this.removeUnusedMapperIndex(dir2, conf);
        }
    }

    private boolean isMapperIndexMustBeRemoved(File mapperIndexDir) {
        File lastModifiedFile = new File(mapperIndexDir, MAPPER_LAST_USED_FILENAME);
        if (!lastModifiedFile.exists()) {
            return false;
        }
        long duration = System.currentTimeMillis() - lastModifiedFile.lastModified();
        return duration > 604800000L;
    }

    private void removeUnusedMapperIndex(File mapperIndexDir, Configuration conf) {
        File lockFile = new File(mapperIndexDir.getParentFile(), mapperIndexDir.getName() + LOCK_SUFFIX);
        try (FileOutputStream out = new FileOutputStream(lockFile);){
            FileLock lock = out.getChannel().lock();
            if (this.isMapperIndexMustBeRemoved(mapperIndexDir)) {
                EoulsanLogger.getLogger().info("Remove  unused mapper index directory: " + mapperIndexDir);
                Path mapperIndexPath = new Path(mapperIndexDir.toURI());
                FileSystem fs = FileSystem.get((URI)mapperIndexDir.toURI(), (Configuration)conf);
                fs.delete(mapperIndexPath, true);
            }
            lock.release();
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().warning("Cannot remove unused mapper index directory (" + mapperIndexDir + "): " + e.getMessage());
        }
    }

    private static final class ExceptionWrapper {
        private IOException exception;

        private ExceptionWrapper() {
        }
    }
}

