/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.annotations.HadoopOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractSAM2BAMModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.HadoopBamUtils;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.SortInputFormat;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.SortRecordReader;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.SortReducer;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.hadoopbamcli.CLIMergingAnySAMOutputFormat;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.hadoopbamcli.Utils;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopJobEmergencyStopTask;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.MapReduceUtils;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;

@HadoopOnly
public class SAM2BAMHadoopModule
extends AbstractSAM2BAMModule {
    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.allPortsRequiredInWorkingDirectory(super.getInputPorts());
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Job job;
        Configuration conf = CommonHadoop.createConfiguration();
        Data samData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
        Data bamData = context.getOutputData(DataFormats.MAPPER_RESULTS_BAM, samData);
        Data indexData = context.getOutputData(DataFormats.MAPPER_RESULTS_INDEX_BAI, samData);
        DataFile samFile = samData.getDataFile();
        DataFile bamFile = bamData.getDataFile();
        DataFile indexFile = indexData.getDataFile();
        Path bamPath = new Path(bamFile.toUri());
        Path workPath = new Path(bamPath.getParent(), bamPath.getName() + ".tmp");
        try {
            job = this.createJobConf(conf, context, samData.getName(), samFile, bamFile, workPath);
            MapReduceUtils.submitAndWaitForJob(job, samData.getName(), 5000, status, "sam2bam");
        }
        catch (EoulsanException | IOException | ClassNotFoundException | InterruptedException e) {
            return status.createTaskResult(e);
        }
        try {
            HadoopBamUtils.mergeSAMInto(bamPath, workPath, "", "", SAMFormat.BAM, job.getConfiguration(), "sort");
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        try {
            DataFile indexerSubmitFile = this.createSubmitFile(bamFile, indexFile);
            Job indexingJob = this.createIndexJob(conf, indexerSubmitFile, "Create " + indexFile + " index file");
            indexingJob.submit();
            HadoopJobEmergencyStopTask.addHadoopJobEmergencyStopTask(indexingJob);
            indexingJob.waitForCompletion(false);
            HadoopJobEmergencyStopTask.removeHadoopJobEmergencyStopTask(indexingJob);
            if (!indexingJob.isSuccessful()) {
                throw new IOException("Error while running Hadoop job for creating " + indexFile + " index file");
            }
            indexerSubmitFile.delete();
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }

    private Job createJobConf(Configuration conf, TaskContext context, String sampleName, DataFile samFile, DataFile bamFile, Path workPath) throws IOException, ClassNotFoundException, InterruptedException {
        FileSystem fs;
        FileStatus status;
        ValidationStringency stringency = ValidationStringency.DEFAULT_STRINGENCY;
        Path input = new Path(samFile.toUri());
        Path output = new Path(bamFile.toUri());
        context.getLogger().info("Input SAM path: " + input);
        context.getLogger().info("Output BAM path: " + output);
        context.getLogger().info("Working path: " + workPath);
        Utils.setHeaderMergerSortOrder(conf, SAMFileHeader.SortOrder.coordinate);
        if (stringency != null) {
            conf.set("hadoopbam.samheaderreader.validation-stringency", stringency.toString());
        }
        String intermediateOutName = output.getName();
        conf.set("hadoopbam.work.filename", intermediateOutName);
        conf.set("hadoopbam.anysam.output-format", SAMFormat.BAM.toString());
        conf.set("hadoopbam.anysam.trust-exts", "true");
        conf.set("hadoopbam.anysam.write-header", "false");
        Utils.configureSampling(workPath, intermediateOutName, conf);
        Job job = Job.getInstance((Configuration)conf, (String)("Sam2Bam (" + sampleName + ", input file: " + input + ", output file: " + workPath + ")"));
        job.setJarByClass(SAM2BAMHadoopModule.class);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(SortReducer.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(SAMRecordWritable.class);
        job.setInputFormatClass(SortInputFormat.class);
        job.setOutputFormatClass(CLIMergingAnySAMOutputFormat.class);
        if (this.getReducerTaskCount() > 0) {
            job.setNumReduceTasks(this.getReducerTaskCount());
        }
        if ((status = (fs = input.getFileSystem(conf)).getFileStatus(input)).isDirectory()) {
            boolean first = true;
            for (FileStatus status2 : fs.listStatus(input)) {
                Path p = status2.getPath();
                if (p.getName().startsWith("_")) continue;
                FileInputFormat.addInputPath((Job)job, (Path)p);
                if (first) {
                    job.getConfiguration().setStrings("hadoopbam.headermerger.inputs", new String[]{p.toString()});
                }
                context.getLogger().info("add path1: " + p);
            }
        } else {
            FileInputFormat.addInputPath((Job)job, (Path)input);
            job.getConfiguration().setStrings("hadoopbam.headermerger.inputs", new String[]{input.toString()});
            context.getLogger().info("add path2: " + input);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)workPath);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        context.getLogger().info("hadoopbam.headermerger.inputs:" + job.getConfiguration().get("hadoopbam.headermerger.inputs"));
        InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)new InputSampler.RandomSampler(0.01, 10000, Math.max(100, job.getNumReduceTasks())));
        return job;
    }

    private DataFile createSubmitFile(DataFile bamFile, DataFile indexFile) throws IOException {
        DataFile out = new DataFile(indexFile.getParent(), indexFile.getName() + ".submitfile");
        OutputStreamWriter writer = new OutputStreamWriter(out.create());
        writer.write(bamFile.getSource() + "\t" + indexFile.getSource());
        ((Writer)writer).close();
        return out;
    }

    private Job createIndexJob(Configuration conf, DataFile submitFile, String jobDescription) throws IOException {
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapreduce.input.lineinputformat.linespermap", "1");
        Job job = Job.getInstance((Configuration)jobConf, (String)jobDescription);
        job.setJarByClass(SortRecordReader.IndexerMapper.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(submitFile.getSource()));
        job.setInputFormatClass(NLineInputFormat.class);
        job.setMapperClass(SortRecordReader.IndexerMapper.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    static void createIndex(Configuration conf, Path bamFile, Path indexFile) throws IOException {
        FSDataInputStream in = FileSystem.get((Configuration)conf).open(bamFile);
        SamReader reader = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS}).validationStringency(ValidationStringency.DEFAULT_STRINGENCY).open(SamInputResource.of((InputStream)in));
        BAMIndexer indexer = new BAMIndexer((OutputStream)indexFile.getFileSystem(conf).create(indexFile), reader.getFileHeader());
        for (SAMRecord rec : reader) {
            indexer.processAlignment(rec);
        }
        indexer.finish();
    }
}

