/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.SAMHeaderHadoopUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;

public class SAMFilterMapper
extends Mapper<Text, Text, Text, Text> {
    static final String MAPPING_QUALITY_THRESOLD_KEY = Globals.PARAMETER_PREFIX + ".samfilter.mapping.quality.threshold";
    private static final Splitter ID_SPLITTER = Splitter.on((char)':').trimResults();
    private final List<String> idFields = new ArrayList<String>();
    private String counterGroup;
    private SAMHeaderHadoopUtils.SAMHeaderWriter samHeaderWriter;
    private final Text outKey = new Text();
    private final Text outValue = new Text();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        EoulsanLogger.initConsoleHandler();
        EoulsanLogger.getLogger().info("Start of setup()");
        Configuration conf = context.getConfiguration();
        if (!EoulsanRuntime.isRuntime()) {
            HadoopEoulsanRuntime.newEoulsanRuntime(conf);
        }
        this.counterGroup = conf.get(CommonHadoop.COUNTER_GROUP_KEY);
        if (this.counterGroup == null) {
            throw new IOException("No counter group defined");
        }
        this.samHeaderWriter = new SAMHeaderHadoopUtils.SAMHeaderWriter(context.getTaskAttemptID().toString());
        EoulsanLogger.getLogger().info("End of setup()");
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String line = value.toString();
        if (this.samHeaderWriter.writeIfHeaderLine((JobContext)context, line)) {
            return;
        }
        context.getCounter(this.counterGroup, MappingCounters.INPUT_ALIGNMENTS_COUNTER.counterName()).increment(1L);
        int indexOfFirstTab = line.indexOf("\t");
        String completeId = line.substring(0, indexOfFirstTab);
        this.idFields.clear();
        for (String e : ID_SPLITTER.split((CharSequence)completeId)) {
            this.idFields.add(e);
        }
        if (this.idFields.size() < 7) {
            int endReadId = completeId.indexOf(47);
            if (endReadId == -1) {
                this.outKey.set(completeId);
                this.outValue.set(line.substring(indexOfFirstTab));
            } else {
                this.outKey.set(line.substring(0, endReadId + 1));
                this.outValue.set(line.substring(endReadId + 1));
            }
        } else {
            int endReadId = completeId.indexOf(32);
            if (endReadId == -1) {
                this.outKey.set(completeId);
                this.outValue.set(line.substring(indexOfFirstTab));
            } else {
                this.outKey.set(line.substring(0, endReadId));
                this.outValue.set(line.substring(endReadId));
            }
        }
        context.write((Object)this.outKey, (Object)this.outValue);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.samHeaderWriter.close((JobContext)context);
    }
}

