/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop;

import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.SAM2BAMHadoopModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.hadoopbamcli.ContextUtil;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.hadoopbamcli.Utils;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.SAMRecordWritable;

final class SortRecordReader
extends RecordReader<LongWritable, SAMRecordWritable> {
    private final RecordReader<LongWritable, SAMRecordWritable> baseRR;
    private Configuration conf;

    public SortRecordReader(RecordReader<LongWritable, SAMRecordWritable> rr) {
        this.baseRR = rr;
    }

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws InterruptedException, IOException {
        this.conf = ContextUtil.getConfiguration((JobContext)ctx);
    }

    public void close() throws IOException {
        this.baseRR.close();
    }

    public float getProgress() throws InterruptedException, IOException {
        return this.baseRR.getProgress();
    }

    public LongWritable getCurrentKey() throws InterruptedException, IOException {
        return (LongWritable)this.baseRR.getCurrentKey();
    }

    public SAMRecordWritable getCurrentValue() throws InterruptedException, IOException {
        return (SAMRecordWritable)this.baseRR.getCurrentValue();
    }

    public boolean nextKeyValue() throws InterruptedException, IOException {
        if (!this.baseRR.nextKeyValue()) {
            return false;
        }
        SAMRecord rec = this.getCurrentValue().get();
        int ri = rec.getReferenceIndex();
        Utils.correctSAMRecordForMerging(rec, this.conf);
        if (rec.getReferenceIndex() != ri) {
            this.getCurrentKey().set(BAMRecordReader.getKey((SAMRecord)rec));
        }
        return true;
    }

    public static final class IndexerMapper
    extends Mapper<LongWritable, Text, NullWritable, NullWritable> {
        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String[] files = value.toString().split("\t");
            if (files.length != 2) {
                throw new IOException("Invalid arguments: " + value);
            }
            Path bamFile = new Path(files[0]);
            Path indexFile = new Path(files[1]);
            SAM2BAMHadoopModule.createIndex(context.getConfiguration(), bamFile, indexFile);
        }
    }
}

