/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.hadoopbamcli;

import fr.ens.biologie.genomique.eoulsan.modules.mapping.hadoop.hadoopbamcli.ContextUtil;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.util.SAMOutputPreparer;

public final class Utils {
    private static String argv0 = null;
    private static Class<?> argv0Class = null;
    public static final String WORK_FILENAME_PROPERTY = "hadoopbam.work.filename";
    private static final String HEADERMERGER_SORTORDER_PROP = "hadoopbam.headermerger.sortorder";
    public static final String HEADERMERGER_INPUTS_PROPERTY = "hadoopbam.headermerger.inputs";
    private static SamFileHeaderMerger headerMerger = null;
    private static String stringencyOptHelp = null;

    public static void printWrapped(PrintStream out, String str) {
        Utils.printWrapped(out, str, 0);
    }

    public static void printWrapped(PrintStream out, String str, int indent) {
        Utils.printWrapped(out, str, indent, 80);
    }

    public static void printWrapped(PrintStream out, String str, int indent, int wrapAt) {
        int pos = indent;
        Scanner words = new Scanner(str);
        if (words.hasNext()) {
            String word = words.next();
            out.print(word);
            pos += word.length();
        }
        boolean addSpace = true;
        while (words.hasNext()) {
            int i;
            String word = words.next();
            int wend = words.match().end();
            pos += word.length();
            if (addSpace) {
                ++pos;
            }
            if (pos < wrapAt) {
                if (addSpace) {
                    out.print(' ');
                }
                out.print(word);
            } else {
                pos = indent + word.length();
                out.print('\n');
                i = indent;
                while (i-- > 0) {
                    out.print(' ');
                }
                out.print(word);
            }
            if (wend < str.length() && str.charAt(wend) == '\n') {
                pos = indent;
                addSpace = false;
                i = wend;
                do {
                    out.print('\n');
                } while (++i < str.length() && str.charAt(i) == '\n');
                i = indent;
                while (i-- > 0) {
                    out.print(' ');
                }
                continue;
            }
            addSpace = true;
        }
        out.print('\n');
    }

    public static String getArgv0() {
        if (argv0 != null) {
            return argv0;
        }
        if (argv0Class == null) {
            return null;
        }
        CodeSource cs = argv0Class.getProtectionDomain().getCodeSource();
        if (cs == null) {
            return null;
        }
        String path = cs.getLocation().getPath();
        argv0 = path.endsWith("/") ? argv0Class.getSimpleName() : new File(path).getName();
        return argv0;
    }

    public static void setArgv0Class(Class<?> cl) {
        argv0Class = cl;
        argv0 = null;
    }

    public static void configureSampling(Path workDir, String outName, Configuration conf) throws IOException {
        Path partition = workDir.getFileSystem(conf).makeQualified(new Path(workDir, "_partitioning" + outName));
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partition);
        try {
            URI partitionURI = new URI(partition.toString() + "#" + partition.getName());
            if (partitionURI.getScheme().equals("file")) {
                return;
            }
            DistributedCache.addCacheFile((URI)partitionURI, (Configuration)conf);
            DistributedCache.createSymlink((Configuration)conf);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getMergeableWorkFile(Path directory, String basePrefix, String basePostfix, TaskAttemptContext ctx, String extension) {
        return new Path(directory, basePrefix + ContextUtil.getConfiguration((JobContext)ctx).get(WORK_FILENAME_PROPERTY) + basePostfix + "-" + String.format("%06d", ctx.getTaskAttemptID().getTaskID().getId()) + (String)(extension.isEmpty() ? extension : "." + extension));
    }

    public static void mergeInto(OutputStream out, Path directory, String basePrefix, String basePostfix, Configuration conf, String commandName) throws IOException {
        FileStatus[] parts;
        FileSystem fs = directory.getFileSystem(conf);
        for (FileStatus part : parts = fs.globStatus(new Path(directory, basePrefix + conf.get(WORK_FILENAME_PROPERTY) + basePostfix + "-[0-9][0-9][0-9][0-9][0-9][0-9]*"))) {
            FSDataInputStream in = fs.open(part.getPath());
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
            in.close();
        }
        for (FileStatus part : parts) {
            fs.delete(part.getPath(), false);
        }
    }

    public static void setHeaderMergerSortOrder(Configuration conf, SAMFileHeader.SortOrder order) {
        conf.set(HEADERMERGER_SORTORDER_PROP, order.name());
    }

    public static SamFileHeaderMerger getSAMHeaderMerger(Configuration conf) throws IOException {
        if (headerMerger != null) {
            return headerMerger;
        }
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
        for (String in : conf.getStrings(HEADERMERGER_INPUTS_PROPERTY)) {
            Path p = new Path(in);
            SamReader r = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)p.getFileSystem(conf).open(p)));
            headers.add(r.getFileHeader());
            r.close();
        }
        String orderStr = conf.get(HEADERMERGER_SORTORDER_PROP);
        SAMFileHeader.SortOrder order = orderStr == null ? SAMFileHeader.SortOrder.unsorted : SAMFileHeader.SortOrder.valueOf((String)orderStr);
        headerMerger = new SamFileHeaderMerger(order, headers, true);
        return headerMerger;
    }

    public static void correctSAMRecordForMerging(SAMRecord r, Configuration conf) throws IOException {
        String rg;
        String pg;
        if (headerMerger == null) {
            Utils.getSAMHeaderMerger(conf);
        }
        SAMFileHeader h = r.getHeader();
        if (headerMerger.hasMergedSequenceDictionary()) {
            int ri = headerMerger.getMergedSequenceIndex(h, r.getReferenceIndex());
            r.setReferenceIndex(ri);
            if (r.getReadPairedFlag()) {
                r.setMateReferenceIndex(headerMerger.getMergedSequenceIndex(h, r.getMateReferenceIndex()).intValue());
            }
        }
        if (headerMerger.hasProgramGroupCollisions() && (pg = (String)r.getAttribute(ReservedTagConstants.PROGRAM_GROUP_ID)) != null) {
            r.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)headerMerger.getProgramGroupId(h, pg));
        }
        if (headerMerger.hasReadGroupCollisions() && (rg = (String)r.getAttribute(ReservedTagConstants.READ_GROUP_ID)) != null) {
            r.setAttribute(ReservedTagConstants.READ_GROUP_ID, (Object)headerMerger.getProgramGroupId(h, rg));
        }
    }

    public static void mergeSAMInto(Path out, Path directory, String basePrefix, String basePostfix, SAMFormat format, Configuration conf, String commandName) throws IOException {
        FSDataOutputStream outs = out.getFileSystem(conf).create(out);
        new SAMOutputPreparer().prepareForRecords((OutputStream)outs, format, Utils.getSAMHeaderMerger(conf).getMergedHeader());
        Utils.mergeInto((OutputStream)outs, directory, basePrefix, basePostfix, conf, commandName);
        if (format == SAMFormat.BAM) {
            outs.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        }
        outs.close();
    }

    public static String getStringencyOptHelp() {
        if (stringencyOptHelp != null) {
            return stringencyOptHelp;
        }
        StringBuilder sb = new StringBuilder("set Picard's validation stringency to S (");
        String last = null;
        for (ValidationStringency v : ValidationStringency.values()) {
            if (last != null) {
                sb.append(last);
                sb.append(", ");
            }
            last = v.name();
        }
        sb.append("or ");
        sb.append(last);
        sb.append(')');
        stringencyOptHelp = sb.toString();
        return stringencyOptHelp;
    }
}

