/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.local;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.ParallelizationMode;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.data.MapperIndexDataFormat;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractReadsMapperModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.FileMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperIndex;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstanceBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.io.UnSynchronizedBufferedWriter;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.logging.Logger;

@LocalOnly
public class ReadsMapperLocalModule
extends AbstractReadsMapperModule {
    @Override
    public ParallelizationMode getParallelizationMode() {
        return ParallelizationMode.OWN_PARALLELIZATION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("reads", DataFormats.READS_FASTQ);
        builder.addPort("mapperindex", new MapperIndexDataFormat(this.getMapper()));
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        OutputPortsBuilder builder = new OutputPortsBuilder();
        builder.addPort("output", DataFormats.MAPPER_RESULTS_SAM);
        builder.addPort("log", DataFormats.MAPPER_RESULTS_LOG);
        return builder.create();
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            LocalReporter reporter = new LocalReporter();
            DataFile archiveIndexFile = context.getInputData(new MapperIndexDataFormat(this.getMapper())).getDataFile();
            File indexDir = new File(StringUtils.filenameWithoutExtension((String)archiveIndexFile.toUri().getPath()));
            Data inData = context.getInputData(DataFormats.READS_FASTQ);
            Data outData = context.getOutputData(DataFormats.MAPPER_RESULTS_SAM, inData);
            File samFile = outData.getDataFile().toFile();
            Data logData = context.getOutputData(DataFormats.MAPPER_RESULTS_LOG, inData);
            File errorFile = logData.getDataFile().toFile();
            String logExtension = "STAR".equals(this.getMapperName()) ? "." : ".log";
            File logFile = new File(samFile.getParentFile(), StringUtils.filenameWithoutExtension((String)errorFile.getName()) + logExtension);
            FastqFormat fastqFormat = inData.getMetadata().getFastqFormat();
            FileMapping fileMapping = this.initMapper(context, fastqFormat, archiveIndexFile, indexDir, (Reporter)reporter);
            if (inData.getDataFileCount() < 1) {
                throw new IOException("No reads file found.");
            }
            if (inData.getDataFileCount() > 2) {
                throw new IOException("Cannot handle more than 2 reads files at the same time.");
            }
            Object logMsg = "";
            if (inData.getDataFileCount() == 1) {
                DataFile inFile = context.getInputData(DataFormats.READS_FASTQ).getDataFile(0);
                EoulsanLogger.getLogger().info("Map file: " + inFile + ", Fastq format: " + fastqFormat + ", use " + fileMapping.getName() + " with " + fileMapping.getThreadNumber() + " threads option");
                MapperProcess process = ReadsMapperLocalModule.mapSE(fileMapping, inFile, errorFile, logFile, context.getLogger());
                status.setCommandLine(process.getCommandLine());
                this.parseSAMResults(process.getStout(), samFile, (Reporter)reporter);
                process.waitFor();
                logMsg = "Mapping reads in " + fastqFormat + " with " + fileMapping.getName() + " (" + inData.getName() + ", " + inFile.getName() + ")";
            }
            if (inData.getDataFileCount() == 2) {
                DataFile inFile1 = context.getInputData(DataFormats.READS_FASTQ).getDataFile(0);
                DataFile inFile2 = context.getInputData(DataFormats.READS_FASTQ).getDataFile(1);
                EoulsanLogger.getLogger().info("Map files: " + inFile1 + "," + inFile2 + ", Fastq format: " + fastqFormat + ", use " + fileMapping.getName() + " with " + fileMapping.getThreadNumber() + " threads option");
                MapperProcess process = ReadsMapperLocalModule.mapPE(fileMapping, inFile1, inFile2, errorFile, logFile, context.getLogger());
                this.parseSAMResults(process.getStout(), samFile, (Reporter)reporter);
                process.waitFor();
                logMsg = "Mapping reads in " + fastqFormat + " with " + fileMapping.getName() + " (" + inData.getName() + ", " + inFile1.getName() + "," + inFile2.getName() + ")";
            }
            fileMapping.throwMappingException();
            status.setDescription((String)logMsg);
            status.setCounters((Reporter)reporter, "reads_mapping");
        }
        catch (FileNotFoundException e) {
            return status.createTaskResult(e, "File not found: " + e.getMessage());
        }
        catch (IOException e) {
            return status.createTaskResult(e, "Error while mapping reads: " + e.getMessage());
        }
        return status.createTaskResult();
    }

    private FileMapping initMapper(TaskContext context, FastqFormat format, DataFile archiveIndexFile, File indexDir, Reporter reporter) throws IOException {
        Mapper mapper = new MapperBuilder(this.getMapper()).withTempDirectory(context.getLocalTempDirectory()).withExecutablesTempDirectory(context.getSettings().getExecutablesTempDirectoryFile()).build();
        MapperInstance mapperInstance = new MapperInstanceBuilder(mapper).withMapperVersion(this.getMapperVersion()).withMapperFlavor(this.getMapperFlavor()).withUseBundledBinaries(this.isUseBundledBinaries()).withDockerImage(this.getMapperDockerImage()).build();
        MapperIndex mapperIndex = mapperInstance.newMapperIndex(archiveIndexFile.open(), indexDir);
        int mapperThreads = this.getMapperLocalThreads();
        if (mapperThreads > Runtime.getRuntime().availableProcessors() || mapperThreads < 1) {
            mapperThreads = Runtime.getRuntime().availableProcessors();
        }
        FileMapping mapping = mapperIndex.newFileMapping(format, this.getMapperArguments(), mapperThreads, false, (ReporterIncrementer)reporter, "reads_mapping");
        context.getWorkflow().deleteOnExit(new DataFile(mapperIndex.getIndexDirectory()));
        return mapping;
    }

    private void parseSAMResults(InputStream samFileInputStream, File samFile, Reporter reporter) throws IOException {
        String line;
        BufferedReader readerResults = FileUtils.createBufferedReader((InputStream)samFileInputStream);
        UnSynchronizedBufferedWriter writer = new UnSynchronizedBufferedWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(samFile), StandardCharsets.ISO_8859_1));
        int entriesParsed = 0;
        while ((line = readerResults.readLine()) != null) {
            int tabPos;
            writer.write(line);
            writer.write(10);
            String trimmedLine = line.trim();
            if ("".equals(trimmedLine) || trimmedLine.startsWith("@") || (tabPos = trimmedLine.indexOf(9)) == -1) continue;
            ++entriesParsed;
            reporter.incrCounter("reads_mapping", MappingCounters.OUTPUT_MAPPING_ALIGNMENTS_COUNTER.counterName(), 1L);
        }
        readerResults.close();
        writer.close();
        EoulsanLogger.getLogger().info(entriesParsed + " entries parsed in " + this.getMapperName() + " output file");
    }

    private static final MapperProcess mapSE(FileMapping fileMapping, DataFile readsFile, File errorFile, File logFile, Logger logger) throws IOException {
        Objects.requireNonNull(fileMapping);
        Objects.requireNonNull(readsFile, "readsFile is null");
        if (!readsFile.exists()) {
            throw new IOException("readsFile1 not exits");
        }
        if (readsFile.isLocalFile() && readsFile.getCompressionType() == CompressionType.NONE) {
            return fileMapping.mapSE(readsFile.toFile(), errorFile, logFile);
        }
        logger.fine("FASTQ file to map: " + readsFile);
        return fileMapping.mapSE(readsFile.open(), errorFile, logFile);
    }

    private static final MapperProcess mapPE(FileMapping fileMapping, DataFile readsFile1, DataFile readsFile2, File errorFile, File logFile, Logger logger) throws IOException {
        Objects.requireNonNull(readsFile1, "readsFile1 is null");
        Objects.requireNonNull(readsFile2, "readsFile2 is null");
        if (!readsFile1.exists()) {
            throw new IOException("readsFile1 not exits");
        }
        if (!readsFile2.exists()) {
            throw new IOException("readsFile1 not exits");
        }
        if (readsFile1.isLocalFile() && readsFile1.getCompressionType() == CompressionType.NONE && readsFile2.isLocalFile() && readsFile2.getCompressionType() == CompressionType.NONE) {
            return fileMapping.mapPE(readsFile1.toFile(), readsFile2.toFile(), errorFile, logFile);
        }
        logger.fine("First pair FASTQ file to map: " + readsFile1);
        logger.fine("Second pair FASTQ file to map: " + readsFile2);
        return fileMapping.mapPE(readsFile1.open(), readsFile2.open(), errorFile, logFile);
    }
}

