/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.local;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractSAMFilterModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.kenetre.bio.SAMComparator;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.MultiReadAlignmentFilter;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.ReadAlignmentFilter;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.ReadAlignmentFilterBuffer;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

@LocalOnly
public class SAMFilterLocalModule
extends AbstractSAMFilterModule {
    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        LocalReporter reporter = new LocalReporter();
        try {
            MultiReadAlignmentFilter filter = this.getAlignmentFilter(context.getGenericLogger(), (ReporterIncrementer)reporter, "sam_filtering");
            EoulsanLogger.getLogger().info("Read alignments filters to apply: " + Joiner.on((String)", ").join((Iterable)filter.getFilterNames()));
            SAMFilterLocalModule.filterSample(context, (Reporter)reporter, status, (ReadAlignmentFilter)filter);
        }
        catch (IOException e) {
            status.createTaskResult(e, "Error while filtering alignments: " + e.getMessage());
        }
        catch (EoulsanException e) {
            status.createTaskResult(e, "Error while initializing filter: " + e.getMessage());
        }
        return status.createTaskResult();
    }

    private static void filterSample(TaskContext context, Reporter reporter, TaskStatus status, ReadAlignmentFilter filter) throws IOException {
        Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
        Data outData = context.getOutputData(DataFormats.MAPPER_RESULTS_SAM, inData);
        DataFile inFile = inData.getDataFile();
        DataFile outFile = outData.getDataFile();
        SAMFilterLocalModule.filterFile(inFile, outFile, reporter, filter, context.getLocalTempDirectory());
        status.setDescription("Filter SAM file (" + inData.getName() + ", " + inFile.getName() + ")");
        status.setCounters(reporter, "sam_filtering");
    }

    private static void filterFile(DataFile inFile, DataFile outFile, Reporter reporter, ReadAlignmentFilter filter, File tmpDir) throws IOException {
        ArrayList records = new ArrayList();
        int counterInput = 0;
        int counterOutput = 0;
        int counterInvalid = 0;
        boolean pairedEnd = false;
        ReadAlignmentFilterBuffer rafb = new ReadAlignmentFilterBuffer(filter);
        EoulsanLogger.getLogger().info("Filter SAM file: " + inFile);
        SamReader inputSam = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)inFile.open()));
        SAMFileWriter outputSam = new SAMFileWriterFactory().setTempDirectory(tmpDir).makeSAMWriter(inputSam.getFileHeader(), false, outFile.create());
        SAMRecordIterator it = inputSam.iterator();
        while (it.hasNext()) {
            SAMRecord samRecord;
            try {
                samRecord = (SAMRecord)it.next();
            }
            catch (SAMFormatException e) {
                ++counterInvalid;
                continue;
            }
            if (counterInput == 0 && samRecord.getReadPairedFlag()) {
                pairedEnd = true;
            }
            ++counterInput;
            if (rafb.addAlignment(samRecord)) continue;
            records.clear();
            records.addAll(rafb.getFilteredAlignments());
            records.sort(new SAMComparator());
            for (SAMRecord r : records) {
                outputSam.addAlignment(r);
                ++counterOutput;
            }
            rafb.addAlignment(samRecord);
        }
        records.clear();
        records.addAll(rafb.getFilteredAlignments());
        records.sort(new SAMComparator());
        for (SAMRecord r : records) {
            outputSam.addAlignment(r);
            ++counterOutput;
        }
        if (pairedEnd) {
            int nbInput = counterInput / 2;
            int nbOutput = counterOutput / 2;
            reporter.incrCounter("sam_filtering", MappingCounters.INPUT_ALIGNMENTS_COUNTER.counterName(), (long)nbInput);
            reporter.incrCounter("sam_filtering", MappingCounters.OUTPUT_FILTERED_ALIGNMENTS_COUNTER.counterName(), (long)nbOutput);
            reporter.incrCounter("sam_filtering", MappingCounters.ALIGNMENTS_WITH_INVALID_SAM_FORMAT.counterName(), (long)(counterInvalid / 2));
            reporter.incrCounter("sam_filtering", MappingCounters.ALIGNMENTS_REJECTED_BY_FILTERS_COUNTER.counterName(), (long)(nbInput - nbOutput));
        } else {
            reporter.incrCounter("sam_filtering", MappingCounters.INPUT_ALIGNMENTS_COUNTER.counterName(), (long)counterInput);
            reporter.incrCounter("sam_filtering", MappingCounters.OUTPUT_FILTERED_ALIGNMENTS_COUNTER.counterName(), (long)counterOutput);
            reporter.incrCounter("sam_filtering", MappingCounters.ALIGNMENTS_WITH_INVALID_SAM_FORMAT.counterName(), (long)counterInvalid);
            reporter.incrCounter("sam_filtering", MappingCounters.ALIGNMENTS_REJECTED_BY_FILTERS_COUNTER.counterName(), (long)(counterInput - counterOutput));
        }
        inputSam.close();
        outputSam.close();
    }
}

