/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping.local;

import fr.ens.biologie.genomique.eoulsan.annotations.HadoopCompatible;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.AbstractSplice2BEDModule;
import fr.ens.biologie.genomique.kenetre.bio.BEDEntry;
import fr.ens.biologie.genomique.kenetre.bio.EntryMetadata;
import fr.ens.biologie.genomique.kenetre.bio.SAMUtils;
import fr.ens.biologie.genomique.kenetre.bio.io.BEDWriter;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.IOException;
import java.io.InputStream;

@HadoopCompatible
public class Splice2BEDModule
extends AbstractSplice2BEDModule {
    private static final String PLUS_COLOR = "255,0,0";
    private static final String MINUS_COLOR = "0,0,255";

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            LocalReporter reporter = new LocalReporter();
            Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
            Data outBEDData = context.getOutputData(DataFormats.MAPPER_RESULT_BED, inData);
            DataFile samFile = inData.getDataFile();
            DataFile bedFile = outBEDData.getDataFile();
            String trackName = inData.getName();
            String trackDescription = inData.getMetadata().get("Description");
            String trackColor = inData.getMetadata().get("TrackColor");
            Splice2BEDModule.convert(samFile, bedFile, trackName, trackDescription, trackColor, (Reporter)reporter);
            status.setDescription("Convert alignments to BED format (" + inData.getName() + ", " + samFile.getName() + ", " + bedFile.getName() + ")");
            status.setCounters((Reporter)reporter, "splice2bed");
            return status.createTaskResult();
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
    }

    private static void convert(DataFile samDataFile, DataFile bedDataFile, String trackName, String trackDescription, String trackColor, Reporter reporter) throws IOException {
        try (SamReader samReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)samDataFile.open()));
             BEDWriter bedWriter = new BEDWriter(bedDataFile.create());){
            EntryMetadata metadata = new EntryMetadata();
            metadata.add("track", "name=\"" + trackName + "\" " + (String)(trackDescription != null ? "description=\"" + trackDescription + "\"" : "") + " itemRgb=\"On\"");
            for (SAMRecord samRecord : samReader) {
                if (samRecord.getReadUnmappedFlag()) continue;
                BEDEntry entry = SAMUtils.parseIntervalsToBEDEntry((SAMRecord)samRecord, (EntryMetadata)metadata);
                entry.setScore(1000);
                if (trackColor != null && !"".equals(trackColor.trim())) {
                    entry.setRgbItem(trackColor.trim());
                } else if (entry.getStrand() == '+') {
                    entry.setRgbItem(PLUS_COLOR);
                } else if (entry.getStrand() == '-') {
                    entry.setRgbItem(MINUS_COLOR);
                }
                bedWriter.write(entry);
                reporter.incrCounter("splice2bed", "alignments processed", 1L);
            }
        }
    }
}

