/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload;

import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.HadoopOnly;
import fr.ens.biologie.genomique.eoulsan.core.ContextUtils;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputDataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatConverter;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.mgmt.hadoop.DistCp;
import fr.ens.biologie.genomique.eoulsan.modules.mgmt.upload.DataFileDistCp;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.PathUtils;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@HadoopOnly
public class HDFSDataDownloadModule
extends AbstractModule {
    public static final String DATAFORMATS_TO_DOWNLOAD_SETTING = "dataformat.to.download";
    public static final String NO_HDFS_DOWNLOAD = "no.hdfs.download";
    public static final String MODULE_NAME = "_download";
    private Configuration conf;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "Download output data from HDFS filesystem";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        this.conf = CommonHadoop.createConfiguration(EoulsanRuntime.getSettings());
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        String noDownloadValue = context.getSettings().getSetting(NO_HDFS_DOWNLOAD);
        if (noDownloadValue != null && "true".equals(noDownloadValue.trim().toLowerCase())) {
            status.setProgressMessage("Download step skipped in settings.");
            return status.createTaskResult();
        }
        String hadoopWorkingPathname = ContextUtils.getHadoopWorkingDirectory(context).getSource();
        EoulsanLogger.getLogger().info("Start copying results.");
        EoulsanLogger.getLogger().info("inpath=" + hadoopWorkingPathname + "\toutpath=" + context.getOutputDirectory());
        Configuration conf = this.conf;
        if (hadoopWorkingPathname == null) {
            throw new NullPointerException("The input path is null");
        }
        if (context.getOutputDirectory() == null) {
            throw new NullPointerException("The output path is null");
        }
        DataFile outputDir = context.getOutputDirectory();
        try {
            Path inPath = new Path(hadoopWorkingPathname);
            if (!PathUtils.isExistingDirectoryFile(inPath, conf)) {
                throw new EoulsanException("The base directory is not a directory: " + inPath);
            }
            HashMap<Object, DataFile> files = new HashMap<Object, DataFile>();
            HashSet outFiles = new HashSet();
            for (StepOutputDataFile stepOutputDataFile : outFiles) {
                DataFile in = stepOutputDataFile.getDataFile();
                DataFile dataFile = new DataFile(outputDir, in.getName() + CompressionType.BZIP2.getExtension());
                files.put(in, dataFile);
            }
            if (files.size() > 0) {
                if (outputDir.isLocalFile()) {
                    for (Map.Entry entry : files.entrySet()) {
                        EoulsanLogger.getLogger().info("Copy " + entry.getKey() + " to " + entry.getValue());
                        new DataFormatConverter((DataFile)entry.getKey(), (DataFile)entry.getValue()).convert();
                    }
                } else {
                    HashMap<DataFile, DataFile> filesToTranscode = new HashMap<DataFile, DataFile>();
                    HashMap<DataFile, DataFile> hashMap = new HashMap<DataFile, DataFile>();
                    for (Map.Entry entry : files.entrySet()) {
                        DataFile src = (DataFile)entry.getKey();
                        DataFile dest = (DataFile)entry.getValue();
                        if (src.getName().equals(dest.getName())) {
                            hashMap.put(src, dest);
                            continue;
                        }
                        DataFile tmp = new DataFile(src.getParent(), dest.getName());
                        filesToTranscode.put(src, tmp);
                        hashMap.put(tmp, dest);
                    }
                    Path jobPath = PathUtils.createTempPath(new Path(hadoopWorkingPathname), "distcp-", "", this.conf);
                    DataFileDistCp dataFileDistCp = new DataFileDistCp(this.conf, jobPath);
                    dataFileDistCp.copy(filesToTranscode);
                    FileSystem fs = jobPath.getFileSystem(conf);
                    if (!fs.delete(jobPath, true)) {
                        EoulsanLogger.getLogger().warning("Cannot remove DataFileDistCp job path: " + jobPath);
                    }
                    this.hadoopDistCp(conf, hashMap);
                }
            }
            StringBuilder logMsg = new StringBuilder();
            for (Map.Entry e : files.entrySet()) {
                logMsg.append("Copy ");
                logMsg.append(e.getKey());
                logMsg.append(" to ");
                logMsg.append(e.getValue());
                logMsg.append('\n');
            }
            status.setProgressMessage(logMsg.toString());
            return status.createTaskResult();
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e, "Error while download results: " + e.getMessage());
        }
    }

    private void hadoopDistCp(Configuration conf, Map<DataFile, DataFile> files) throws EoulsanException {
        DistCp distcp = new DistCp(conf);
        HashMap<DataFile, Object> toCopy = new HashMap<DataFile, Object>();
        for (Map.Entry<DataFile, DataFile> entry : files.entrySet()) {
            Object inputFiles;
            DataFile destDir;
            try {
                destDir = entry.getValue().getParent();
            }
            catch (IOException exp) {
                throw new EoulsanException(exp.getMessage(), exp);
            }
            if (destDir == null) {
                throw new EoulsanException("Destination directory is null.");
            }
            if (toCopy.containsKey(destDir)) {
                inputFiles = (Set)toCopy.get(destDir);
            } else {
                inputFiles = new HashSet();
                toCopy.put(destDir, inputFiles);
            }
            inputFiles.add(entry.getKey());
        }
        for (Map.Entry<DataFile, DataFile> entry : toCopy.entrySet()) {
            ArrayList<String> argsList = new ArrayList<String>();
            for (DataFile f : (Set)((Object)entry.getValue())) {
                argsList.add(f.toString());
            }
            argsList.add(entry.getKey().toString());
            String[] args = argsList.toArray(new String[0]);
            distcp.runWithException(args);
        }
    }
}

