/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.multiqc;

import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.multiqc.InputPreprocessor;
import java.io.File;
import java.io.IOException;

public class FastQCInputPreprocessor
implements InputPreprocessor {
    public static final String REPORT_NAME = "fastqc";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public DataFormat getDataFormat() {
        return DataFormats.FASTQC_REPORT_ZIP;
    }

    @Override
    public void preprocess(TaskContext context, Data data, File multiQCInputDirectory) throws IOException {
        String name = data.getName();
        int fileCount = data.getDataFileCount();
        for (int i = 0; i < fileCount; ++i) {
            DataFile symlink = new DataFile(multiQCInputDirectory, name + (String)(fileCount <= 1 ? "" : "_read" + i) + "_fastqc.zip");
            DataFile fastQCReportFile = data.getDataFile(i);
            if (!fastQCReportFile.exists()) continue;
            fastQCReportFile.symlink(symlink);
        }
    }
}

