/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.multiqc;

import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.multiqc.InputPreprocessor;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;

public class MapperInputPreprocessor
implements InputPreprocessor {
    public static final String REPORT_NAME = "mapreads";
    private static final String STAR_LOG_SUFFIX = "Log.final.out";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public DataFormat getDataFormat() {
        return DataFormats.MAPPER_RESULTS_LOG;
    }

    @Override
    public void preprocess(TaskContext context, Data data, File multiQCInputDirectory) throws IOException {
        String name = data.getName();
        DataFile symlink = new DataFile(multiQCInputDirectory, name + ".samlog");
        DataFile logFile = data.getDataFile();
        if (!logFile.exists()) {
            return;
        }
        logFile = logFile.toRealDataFile();
        logFile.symlink(symlink);
        DataFile starLog = new DataFile(logFile.getParent(), StringUtils.filenameWithoutExtension((String)logFile.getName()) + ".Log.final.out");
        if (starLog.exists()) {
            DataFile starLogSymlink = new DataFile(multiQCInputDirectory, name + STAR_LOG_SUFFIX);
            starLog.symlink(starLogSymlink);
        }
    }
}

